/********************************** (C) COPYRIGHT *******************************
* File Name          : USBX_DEVICE.C
* Author             : MJX
* Version            : V1.00
* Date               : 2020/05/25
* Description        : ͨUSB豸س
*******************************************************************************/



/******************************************************************************/
/* ͷļ */	
#include "MAIN.H"	 															/* ͷļ */
#include "USB_DESC.H"	 														/* USB豸ͷļ */

/******************************************************************************/
/*  */

#pragma	modp2
#pragma	NOAREGS


/* ÿUSBXBUFFERռ1024ֽXRAM,ǰ3DEVICE256ֽ(˵,δ),HUBһֻ64(EP0)+2(EP1)=66ֽ,ʿճ190ֽ.
   ճ190*4;: ڸUSBXصñ(bUSBX_XRAM_OFSԶƫ),X0SetupLen~X3SetupLen;
   ʣµ,USBX0Ĳʹ(ʱرbUSBX_XRAM_OFSԶƫ,ܱԶƫƵUSBX1~X3),
   USBX1~X3ʣȫֵĻUSBX޹صĻ */

/* /ӳʹõı,пܱжϷ̬޸,volatileʶ */

/* ¶ֻʽϱⱻռ,һ²ᱻռ,趨 */
UINT8X	X0D0Ep0Buffer[ UX_EP0_SIZE_D4 ]	_at_ ((UINT16)pX0D0_EP0_BUF);	// USBX0 dev0 EP0 bufferע⣺ԶƫƵUSBX1~X3
UINT8X	X1D0Ep0Buffer[ UX_EP0_SIZE_D4 ]	_at_ ((UINT16)pX1D0_EP0_BUF);	// USBX1 dev0 EP0 buffer
UINT8X	X2D0Ep0Buffer[ UX_EP0_SIZE_D4 ]	_at_ ((UINT16)pX2D0_EP0_BUF);	// USBX2 dev0 EP0 buffer
UINT8X	X3D0Ep0Buffer[ UX_EP0_SIZE_D4 ]	_at_ ((UINT16)pX3D0_EP0_BUF);	// USBX3 dev0 EP0 buffer
UINT8X	X0D1Ep0Buffer[ UX_EP0_SIZE_D4 ]	_at_ ((UINT16)pX0D1_EP0_BUF);	// USBX0 dev1 EP0 bufferע⣺ԶƫƵUSBX1~X3
UINT8X	X1D1Ep0Buffer[ UX_EP0_SIZE_D4 ]	_at_ ((UINT16)pX1D1_EP0_BUF);	// USBX1 dev1 EP0 buffer
UINT8X	X2D1Ep0Buffer[ UX_EP0_SIZE_D4 ]	_at_ ((UINT16)pX2D1_EP0_BUF);	// USBX2 dev1 EP0 buffer
UINT8X	X3D1Ep0Buffer[ UX_EP0_SIZE_D4 ]	_at_ ((UINT16)pX3D1_EP0_BUF);	// USBX3 dev1 EP0 buffer
UINT8X	X0D2Ep0Buffer[ UX_EP0_SIZE_D4 ]	_at_ ((UINT16)pX0D2_EP0_BUF);	// USBX0 dev2 EP0 bufferע⣺ԶƫƵUSBX1~X3
UINT8X	X1D2Ep0Buffer[ UX_EP0_SIZE_D4 ]	_at_ ((UINT16)pX1D2_EP0_BUF);	// USBX1 dev2 EP0 buffer
UINT8X	X2D2Ep0Buffer[ UX_EP0_SIZE_D4 ]	_at_ ((UINT16)pX2D2_EP0_BUF);	// USBX2 dev2 EP0 buffer
UINT8X	X3D2Ep0Buffer[ UX_EP0_SIZE_D4 ]	_at_ ((UINT16)pX3D2_EP0_BUF);	// USBX3 dev2 EP0 buffer
UINT8X	X0HBEp0Buffer[ UX_EP0_SIZE_D4 ]	_at_ ((UINT16)pX0HB_EP0_BUF);	// USBX0 hub EP0 bufferע⣺ԶƫƵUSBX1~X3
UINT8X	X1HBEp0Buffer[ UX_EP0_SIZE_D4 ]	_at_ ((UINT16)pX1HB_EP0_BUF);	// USBX1 hub EP0 buffer
UINT8X	X2HBEp0Buffer[ UX_EP0_SIZE_D4 ]	_at_ ((UINT16)pX2HB_EP0_BUF);	// USBX2 hub EP0 buffer
UINT8X	X3HBEp0Buffer[ UX_EP0_SIZE_D4 ]	_at_ ((UINT16)pX3HB_EP0_BUF);	// USBX3 hub EP0 buffer

UINT8X	X0D0Ep1Buffer[UX_EP1_SIZE_D5]	_at_ ((UINT16)(pUSBX0_BUF_DEV0+UX_EP1_ADDR));	// USBX0 dev0 EP1 bufferע⣺ԶƫƵUSBX1~X3


/* ҪbUSBX_XRAM_OFSԶƫ,ڸUSBXر */
UINT8X	X0D0UsbConfig		_at_ ((UINT16)pUSBX0_BUF_HUB+UX_EP1_ADDR+2);	// USBX0 dev0ñ־ע⣺ԶƫƵUSBX1~X3
UINT8X	X0D1UsbConfig		_at_ ((UINT16)pUSBX0_BUF_HUB+UX_EP1_ADDR+3);	// USBX0 dev1ñ־ע⣺ԶƫƵUSBX1~X3
UINT8X	X0D2UsbConfig		_at_ ((UINT16)pUSBX0_BUF_HUB+UX_EP1_ADDR+4);	// USBX0 dev2ñ־ע⣺ԶƫƵUSBX1~X3
UINT8X	X0HBUsbConfig		_at_ ((UINT16)pUSBX0_BUF_HUB+UX_EP1_ADDR+5);	// USBX0 hubñ־ע⣺ԶƫƵUSBX1~X3

UINT8X	X1D0UsbConfig		_at_ ((UINT16)pUSBX1_BUF_HUB+UX_EP1_ADDR+2);	// USBX1 dev0ñ־
UINT8X	X1D1UsbConfig		_at_ ((UINT16)pUSBX1_BUF_HUB+UX_EP1_ADDR+3);	// USBX1 dev1ñ־
UINT8X	X1D2UsbConfig		_at_ ((UINT16)pUSBX1_BUF_HUB+UX_EP1_ADDR+4);	// USBX1 dev2ñ־
UINT8X	X1HBUsbConfig		_at_ ((UINT16)pUSBX1_BUF_HUB+UX_EP1_ADDR+5);	// USBX1 hubñ־

UINT8X	X2D0UsbConfig		_at_ ((UINT16)pUSBX2_BUF_HUB+UX_EP1_ADDR+2);	// USBX2 dev0ñ־
UINT8X	X2D1UsbConfig		_at_ ((UINT16)pUSBX2_BUF_HUB+UX_EP1_ADDR+3);	// USBX2 dev1ñ־
UINT8X	X2D2UsbConfig		_at_ ((UINT16)pUSBX2_BUF_HUB+UX_EP1_ADDR+4);	// USBX2 dev2ñ־
UINT8X	X2HBUsbConfig		_at_ ((UINT16)pUSBX2_BUF_HUB+UX_EP1_ADDR+5);	// USBX2 hubñ־

UINT8X	X3D0UsbConfig		_at_ ((UINT16)pUSBX3_BUF_HUB+UX_EP1_ADDR+2);	// USBX3 dev0ñ־
UINT8X	X3D1UsbConfig		_at_ ((UINT16)pUSBX3_BUF_HUB+UX_EP1_ADDR+3);	// USBX3 dev1ñ־
UINT8X	X3D2UsbConfig		_at_ ((UINT16)pUSBX3_BUF_HUB+UX_EP1_ADDR+4);	// USBX3 dev2ñ־
UINT8X	X3HBUsbConfig		_at_ ((UINT16)pUSBX3_BUF_HUB+UX_EP1_ADDR+5);	// USBX3 hubñ־

UINT8XV	X0DevBitFlag[4]		_at_ ((UINT16)pUSBX0_BUF_HUB+UX_EP1_ADDR+6);	// USBX0豸λ־ע⣺ԶƫƵUSBX1~X3
UINT8XV	X1DevBitFlag[4]		_at_ ((UINT16)pUSBX1_BUF_HUB+UX_EP1_ADDR+6);	// USBX1豸λ־
UINT8XV	X2DevBitFlag[4]		_at_ ((UINT16)pUSBX2_BUF_HUB+UX_EP1_ADDR+6);	// USBX2豸λ־
UINT8XV	X3DevBitFlag[4]		_at_ ((UINT16)pUSBX3_BUF_HUB+UX_EP1_ADDR+6);	// USBX3豸λ־


UINT8X	X0D0SetupReqCode	_at_ ((UINT16)pUSBX0_BUF_HUB+UX_EP1_ADDR+10);	// setup request code for USBX0 dev0ע⣺ԶƫƵUSBX1~X3
UINT8X	X0D1SetupReqCode	_at_ ((UINT16)pUSBX0_BUF_HUB+UX_EP1_ADDR+11);	// setup request code for USBX0 dev1ע⣺ԶƫƵUSBX1~X3
UINT8X	X0D2SetupReqCode	_at_ ((UINT16)pUSBX0_BUF_HUB+UX_EP1_ADDR+12);	// setup request code for USBX0 dev2ע⣺ԶƫƵUSBX1~X3
UINT8X	X0HBSetupReqCode	_at_ ((UINT16)pUSBX0_BUF_HUB+UX_EP1_ADDR+13);	// setup request code for USBX0 hubע⣺ԶƫƵUSBX1~X3

UINT8X	X1D0SetupReqCode	_at_ ((UINT16)pUSBX1_BUF_HUB+UX_EP1_ADDR+10);
UINT8X	X1D1SetupReqCode	_at_ ((UINT16)pUSBX1_BUF_HUB+UX_EP1_ADDR+11);
UINT8X	X1D2SetupReqCode	_at_ ((UINT16)pUSBX1_BUF_HUB+UX_EP1_ADDR+12);
UINT8X	X1HBSetupReqCode	_at_ ((UINT16)pUSBX1_BUF_HUB+UX_EP1_ADDR+13);

UINT8X	X2D0SetupReqCode	_at_ ((UINT16)pUSBX2_BUF_HUB+UX_EP1_ADDR+10);
UINT8X	X2D1SetupReqCode	_at_ ((UINT16)pUSBX2_BUF_HUB+UX_EP1_ADDR+11);
UINT8X	X2D2SetupReqCode	_at_ ((UINT16)pUSBX2_BUF_HUB+UX_EP1_ADDR+12);
UINT8X	X2HBSetupReqCode	_at_ ((UINT16)pUSBX2_BUF_HUB+UX_EP1_ADDR+13);

UINT8X	X3D0SetupReqCode	_at_ ((UINT16)pUSBX3_BUF_HUB+UX_EP1_ADDR+10);
UINT8X	X3D1SetupReqCode	_at_ ((UINT16)pUSBX3_BUF_HUB+UX_EP1_ADDR+11);
UINT8X	X3D2SetupReqCode	_at_ ((UINT16)pUSBX3_BUF_HUB+UX_EP1_ADDR+12);
UINT8X	X3HBSetupReqCode	_at_ ((UINT16)pUSBX3_BUF_HUB+UX_EP1_ADDR+13);

UINT16X	X0D0SetupLen		_at_ ((UINT16)pUSBX0_BUF_HUB+UX_EP1_ADDR+14);	// setup length for USBX0 dev0ע⣺ԶƫƵUSBX1~X3
UINT16X	X0D1SetupLen		_at_ ((UINT16)pUSBX0_BUF_HUB+UX_EP1_ADDR+16);	// setup length for USBX0 dev1ע⣺ԶƫƵUSBX1~X3
UINT16X	X0D2SetupLen		_at_ ((UINT16)pUSBX0_BUF_HUB+UX_EP1_ADDR+18);	// setup length for USBX0 dev2ע⣺ԶƫƵUSBX1~X3
UINT16X	X0HBSetupLen		_at_ ((UINT16)pUSBX0_BUF_HUB+UX_EP1_ADDR+20);	// setup length for USBX0 hubע⣺ԶƫƵUSBX1~X3

UINT16X	X1D0SetupLen		_at_ ((UINT16)pUSBX1_BUF_HUB+UX_EP1_ADDR+14);
UINT16X	X1D1SetupLen		_at_ ((UINT16)pUSBX1_BUF_HUB+UX_EP1_ADDR+16);
UINT16X	X1D2SetupLen		_at_ ((UINT16)pUSBX1_BUF_HUB+UX_EP1_ADDR+18);
UINT16X	X1HBSetupLen		_at_ ((UINT16)pUSBX1_BUF_HUB+UX_EP1_ADDR+20);

UINT16X	X2D0SetupLen		_at_ ((UINT16)pUSBX2_BUF_HUB+UX_EP1_ADDR+14);
UINT16X	X2D1SetupLen		_at_ ((UINT16)pUSBX2_BUF_HUB+UX_EP1_ADDR+16);
UINT16X	X2D2SetupLen		_at_ ((UINT16)pUSBX2_BUF_HUB+UX_EP1_ADDR+18);
UINT16X	X2HBSetupLen		_at_ ((UINT16)pUSBX2_BUF_HUB+UX_EP1_ADDR+20);

UINT16X	X3D0SetupLen		_at_ ((UINT16)pUSBX3_BUF_HUB+UX_EP1_ADDR+14);
UINT16X	X3D1SetupLen		_at_ ((UINT16)pUSBX3_BUF_HUB+UX_EP1_ADDR+16);
UINT16X	X3D2SetupLen		_at_ ((UINT16)pUSBX3_BUF_HUB+UX_EP1_ADDR+18);
UINT16X	X3HBSetupLen		_at_ ((UINT16)pUSBX3_BUF_HUB+UX_EP1_ADDR+20);

PUINT8	xdata X0D0pDescr	_at_ ((UINT16)pUSBX0_BUF_HUB+UX_EP1_ADDR+22);	// point descriptor for USBX0 dev0ע⣺ԶƫƵUSBX1~X3
PUINT8	xdata X0D1pDescr	_at_ ((UINT16)pUSBX0_BUF_HUB+UX_EP1_ADDR+25);	// point descriptor for USBX0 dev1ע⣺ԶƫƵUSBX1~X3
PUINT8	xdata X0D2pDescr	_at_ ((UINT16)pUSBX0_BUF_HUB+UX_EP1_ADDR+28);	// point descriptor for USBX0 dev2ע⣺ԶƫƵUSBX1~X3
PUINT8	xdata X0HBpDescr	_at_ ((UINT16)pUSBX0_BUF_HUB+UX_EP1_ADDR+31);	// point descriptor for USBX0 hubע⣺ԶƫƵUSBX1~X3

PUINT8	xdata X1D0pDescr	_at_ ((UINT16)pUSBX1_BUF_HUB+UX_EP1_ADDR+22);
PUINT8	xdata X1D1pDescr	_at_ ((UINT16)pUSBX1_BUF_HUB+UX_EP1_ADDR+25);
PUINT8	xdata X1D2pDescr	_at_ ((UINT16)pUSBX1_BUF_HUB+UX_EP1_ADDR+28);
PUINT8	xdata X1HBpDescr	_at_ ((UINT16)pUSBX1_BUF_HUB+UX_EP1_ADDR+31);

PUINT8	xdata X2D0pDescr	_at_ ((UINT16)pUSBX2_BUF_HUB+UX_EP1_ADDR+22);
PUINT8	xdata X2D1pDescr	_at_ ((UINT16)pUSBX2_BUF_HUB+UX_EP1_ADDR+25);
PUINT8	xdata X2D2pDescr	_at_ ((UINT16)pUSBX2_BUF_HUB+UX_EP1_ADDR+28);
PUINT8	xdata X2HBpDescr	_at_ ((UINT16)pUSBX2_BUF_HUB+UX_EP1_ADDR+31);

PUINT8	xdata X3D0pDescr	_at_ ((UINT16)pUSBX3_BUF_HUB+UX_EP1_ADDR+22);
PUINT8	xdata X3D1pDescr	_at_ ((UINT16)pUSBX3_BUF_HUB+UX_EP1_ADDR+25);
PUINT8	xdata X3D2pDescr	_at_ ((UINT16)pUSBX3_BUF_HUB+UX_EP1_ADDR+28);
PUINT8	xdata X3HBpDescr	_at_ ((UINT16)pUSBX3_BUF_HUB+UX_EP1_ADDR+31);

UINT8X	X0Reserved[6]		_at_ ((UINT16)pUSBX0_BUF_HUB+UX_EP1_ADDR+34);	// reserved for USBX0 hubע⣺ԶƫƵUSBX1~X3
UINT8X	X1Reserved[6]		_at_ ((UINT16)pUSBX1_BUF_HUB+UX_EP1_ADDR+34);
UINT8X	X2Reserved[6]		_at_ ((UINT16)pUSBX2_BUF_HUB+UX_EP1_ADDR+34);
UINT8X	X3Reserved[6]		_at_ ((UINT16)pUSBX3_BUF_HUB+UX_EP1_ADDR+34);

UINT8XV	X0D0_PROTOCOL		_at_ ((UINT16)pUSBX0_BUF_HUB+UX_EP1_ADDR+50);	// for USBX0 dev0ע⣺ԶƫƵUSBX1~X3
UINT8XV	X0D1_PROTOCOL		_at_ ((UINT16)pUSBX0_BUF_HUB+UX_EP1_ADDR+51);	// for USBX0 dev1ע⣺ԶƫƵUSBX1~X3
UINT8XV	X0D2_PROTOCOL		_at_ ((UINT16)pUSBX0_BUF_HUB+UX_EP1_ADDR+52);	// for USBX0 dev2ע⣺ԶƫƵUSBX1~X3
UINT8XV	X1D0_PROTOCOL		_at_ ((UINT16)pUSBX1_BUF_HUB+UX_EP1_ADDR+50);
UINT8XV	X1D1_PROTOCOL		_at_ ((UINT16)pUSBX1_BUF_HUB+UX_EP1_ADDR+51);
UINT8XV	X1D2_PROTOCOL		_at_ ((UINT16)pUSBX1_BUF_HUB+UX_EP1_ADDR+52);
UINT8XV	X2D0_PROTOCOL		_at_ ((UINT16)pUSBX2_BUF_HUB+UX_EP1_ADDR+50);
UINT8XV	X2D1_PROTOCOL		_at_ ((UINT16)pUSBX2_BUF_HUB+UX_EP1_ADDR+51);
UINT8XV	X2D2_PROTOCOL		_at_ ((UINT16)pUSBX2_BUF_HUB+UX_EP1_ADDR+52);
UINT8XV	X3D0_PROTOCOL		_at_ ((UINT16)pUSBX3_BUF_HUB+UX_EP1_ADDR+50);
UINT8XV	X3D1_PROTOCOL		_at_ ((UINT16)pUSBX3_BUF_HUB+UX_EP1_ADDR+51);
UINT8XV	X3D2_PROTOCOL		_at_ ((UINT16)pUSBX3_BUF_HUB+UX_EP1_ADDR+52);

UINT8X  Sp_SetReport_Len = 0x00;											/* SetReport־ */
UINT8X  Sp_SetReport_Pack[ 128 ];											/* SetReportݰ */
UINT8X  Sp_SetReport_Index = 0x00;											/* SetReportӦ(4λΪ豸\4λΪӿڱ) */
UINT8X  Sp_SetReport_Value = 0x00;                                          /* SetReportӦı */
UINT8X  Sp_SetReport_SaveLen = 0x00;                                        
/* ֹԶƫƵĴ洢򣬳ÿռ䣬ڱ棬ʵ޶Ӧϵ */

/* Ϊصز */



/*******************************************************************************
* Function Name  : USBX0_Dev0_Init
* Description    : USB豸1豸ʼ	  
* Input          : mod: 0: clear, 1:reset&disable, 2:reset&enable
* Output         : None
* Return         : None
*******************************************************************************/
void USBX0_Dev0_Init( UINT8 mod ) 
{
//	pX0D0_EP1RES = bUEP_X_AUTO_TOG | UEP_X_RES_NAK;
//	pX0D0_EP2RES = bUEP_X_AUTO_TOG | UEP_X_RES_NAK;
//	pX0D0_EP3RES = bUEP_X_AUTO_TOG | UEP_X_RES_NAK;
//	pX0D0_EP4RES = bUEP_X_AUTO_TOG | UEP_X_RES_NAK;
//	pX0D0_EP5RES = bUEP_X_AUTO_TOG | UEP_X_RES_NAK;
//	pX0D0_EP6RES = bUEP_X_AUTO_TOG | UEP_X_RES_NAK;
	pX0D0_EP1RES = UEP_X_RES_NAK;
	pX0D0_EP2RES = UEP_X_RES_NAK;
	pX0D0_EP3RES = UEP_X_RES_NAK;
	pX0D0_EP4RES = UEP_X_RES_NAK;
	pX0D0_EP5RES = UEP_X_RES_NAK;
	pX0D0_EP6RES = UEP_X_RES_NAK;
	if( mod ) 
	{
		pX0D0_EP0RES = UEP_R_RES_ACK | UEP_T_RES_NAK;
		pX0D0_EP_MOD = ( mod >= 2 ? bUX_DEV_EN : 0 );  							/* ALL EPx=IN,bUX_DEV_EN=? */
		pX0D0_ADDR = 0x00;
//		X0DevBitFlag[ 0 ] = X0D0UsbConfig = 0x00;
		X0D0UsbConfig = 0x00;
		X0D0SetupReqCode = 0xFF;
		pUSBX0_IF = bUX_IF_D0_TRANS;  											/* clear */
	}
}

/*******************************************************************************
* Function Name  : USBX0_Dev1_Init
* Description    : USB豸2豸ʼ	  
* Input          : mod: 0: clear, 1:reset&disable, 2:reset&enable
* Output         : None
* Return         : None
*******************************************************************************/
void USBX0_Dev1_Init( UINT8 mod ) 
{
//	pX0D1_EP1RES = bUEP_X_AUTO_TOG | UEP_X_RES_NAK;
//	pX0D1_EP2RES = bUEP_X_AUTO_TOG | UEP_X_RES_NAK;
//	pX0D1_EP3RES = bUEP_X_AUTO_TOG | UEP_X_RES_NAK;
//	pX0D1_EP4RES = bUEP_X_AUTO_TOG | UEP_X_RES_NAK;
//	pX0D1_EP5RES = bUEP_X_AUTO_TOG | UEP_X_RES_NAK;
//	pX0D1_EP6RES = bUEP_X_AUTO_TOG | UEP_X_RES_NAK;
	pX0D1_EP1RES = UEP_X_RES_NAK;
	pX0D1_EP2RES = UEP_X_RES_NAK;
	pX0D1_EP3RES = UEP_X_RES_NAK;
	pX0D1_EP4RES = UEP_X_RES_NAK;
	pX0D1_EP5RES = UEP_X_RES_NAK;
	pX0D1_EP6RES = UEP_X_RES_NAK;
	if( mod ) 
	{
		pX0D1_EP0RES = UEP_R_RES_ACK | UEP_T_RES_NAK;
		pX0D1_EP_MOD = ( mod >= 2 ? bUX_DEV_EN : 0 );  						/* ALL EPx=IN,bUX_DEV_EN=? */
		pX0D1_ADDR = 0x00;
//		X0DevBitFlag[ 1 ] = X0D1UsbConfig = 0x00;
		X0D1UsbConfig = 0x00;
		X0D1SetupReqCode = 0xFF;
		pUSBX0_IF = bUX_IF_D1_TRANS;
	}
}

/*******************************************************************************
* Function Name  : USBX0_Dev2_Init
* Description    : USB豸3豸ʼ	  
* Input          : mod: 0: clear, 1:reset&disable, 2:reset&enable
* Output         : None
* Return         : None
*******************************************************************************/
void USBX0_Dev2_Init( UINT8 mod ) 
{
//	pX0D2_EP1RES = bUEP_X_AUTO_TOG | UEP_X_RES_NAK;
//	pX0D2_EP2RES = bUEP_X_AUTO_TOG | UEP_X_RES_NAK;
//	pX0D2_EP3RES = bUEP_X_AUTO_TOG | UEP_X_RES_NAK;
//	pX0D2_EP4RES = bUEP_X_AUTO_TOG | UEP_X_RES_NAK;
//	pX0D2_EP5RES = bUEP_X_AUTO_TOG | UEP_X_RES_NAK;
//	pX0D2_EP6RES = bUEP_X_AUTO_TOG | UEP_X_RES_NAK;
	pX0D2_EP1RES = UEP_X_RES_NAK;
	pX0D2_EP2RES = UEP_X_RES_NAK;
	pX0D2_EP3RES = UEP_X_RES_NAK;
	pX0D2_EP4RES = UEP_X_RES_NAK;
	pX0D2_EP5RES = UEP_X_RES_NAK;
	pX0D2_EP6RES = UEP_X_RES_NAK;
	if( mod ) 
	{
		pX0D2_EP0RES = UEP_R_RES_ACK | UEP_T_RES_NAK;
		pX0D2_EP_MOD = ( mod >= 2 ? bUX_DEV_EN : 0 ); 						/* ALL EPx=IN,bUX_DEV_EN=? */
		pX0D2_ADDR = 0x00;
//		X0DevBitFlag[ 2 ] = X0D2UsbConfig = 0x00;
		X0D2UsbConfig = 0x00;
		X0D2SetupReqCode = 0xFF;
		pUSBX0_IF = bUX_IF_D2_TRANS;  
	}
}

/*******************************************************************************
* Function Name  : USBX0_Hub_Init
* Description    : USBX豸HUB豸ʼ
* Input          : reset=FALSE: clear, =TRUE:reset&start
* Output         : None
* Return         : None
*******************************************************************************/
void USBX0_Hub_Init( BOOL reset )  
{
	UINT8  mod;

	pUSBX0_IE = 0x00;
//	pX0HB_EP1RES = bUEP_X_AUTO_TOG | UEP_X_RES_NAK;
	pX0HB_EP1RES = UEP_X_RES_NAK;
	mod = reset ? 1 : 0;
	USBX0_Dev0_Init( mod );
	USBX0_Dev1_Init( mod );
	USBX0_Dev2_Init( mod );
	if( reset ) 
	{
		pX0HB_EP0RES = UEP_R_RES_ACK | UEP_T_RES_NAK;
		pX0HB_ADDR = 0x00;
		X0HBUsbConfig = 0x00;
		X0HBSetupReqCode = 0xFF;
		pUSBX0_CTRL = bUX_DP_PU_EN;  											/* bUX_HUB_EP4_EN=0 */
		pUSBX0_IF = 0xFF;  														/* clear all interrupt flag */
	}
	pUSBX0_IE = bUX_IE_TRANSFER | bUX_IE_BUS_RST | bUX_IE_SUSPEND;  			/* bUX_IE_NAK=0,bUX_IE_SOF=0 */
}

/*******************************************************************************
* Function Name  : USBX_Device_Init
* Description    : USBX豸ʼ
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void USBX_Device_Init( void ) 
{
	IE_USBX = 0;
	IP_EX |= bIP_USBX;
	SAFE_MOD = 0x55;
	SAFE_MOD = 0xAA;
	GLOBAL_CFG |= bXIR_XSFR;
	USBX_SEL = bUSBX_XSFR_OFS | bUSBX_XRAM_OFS | 0;  							/* USBXԶƫ,ͨUSBX0дUSBX0 */
	USBX0_Hub_Init( TRUE );
	X0DevBitFlag[ 0 ] = 0x00;  	
	X0DevBitFlag[ 1 ] = 0x00;  	
	X0DevBitFlag[ 2 ] = 0x00;  	
	X0DevBitFlag[ 3 ] = 0x00;  								
	USBX_SEL = bUSBX_XSFR_OFS | bUSBX_XRAM_OFS | 1;  							/* USBXԶƫ,ͨUSBX0дUSBX1 */
	USBX0_Hub_Init( TRUE );
	X0DevBitFlag[ 0 ] = 0x00;  	
	X0DevBitFlag[ 1 ] = 0x00;  	
	X0DevBitFlag[ 2 ] = 0x00;  	
	X0DevBitFlag[ 3 ] = 0x00;  
	USBX_SEL = bUSBX_XSFR_OFS | bUSBX_XRAM_OFS | 2;  							/* USBXԶƫ,ͨUSBX0дUSBX2 */
	USBX0_Hub_Init( TRUE );
	X0DevBitFlag[ 0 ] = 0x00;  	
	X0DevBitFlag[ 1 ] = 0x00;  	
	X0DevBitFlag[ 2 ] = 0x00;  	
	X0DevBitFlag[ 3 ] = 0x00;  
	USBX_SEL = bUSBX_XSFR_OFS | bUSBX_XRAM_OFS | 3;  							/* USBXԶƫ,ͨUSBX0дUSBX3 */
	USBX0_Hub_Init( TRUE );
	X0DevBitFlag[ 0 ] = 0x00;  	
	X0DevBitFlag[ 1 ] = 0x00;  	
	X0DevBitFlag[ 2 ] = 0x00;  	
	X0DevBitFlag[ 3 ] = 0x00;   
	USBX_SEL = 0x00;  															/* Զƫ	*/
	PCx_ActionNum = 0x00;
	PCx_PassUSB_ActionNum = 0x00;
	PCx_Dev3_Status = 0x00;
	IE_USBX = 1;
}

/*******************************************************************************
* Function Name  : USBX_ThisHub_EP1IntUp
* Description    : USBX豸ڹرжϺΪǰUSBXϴHUBж֪ͨ, 0#~3#豸
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
UINT8 USBX_ThisHub_EP1IntUp( UINT8 portbit )
{
	UINT8	i;	
	
	if( ( pX0HB_EP1RES & MASK_UEP_X_RES ) != UEP_X_RES_ACK ) 
	{  
		/* free */
//		printf("Up%x:%x\n",(UINT16)(USBX_SEL& 0x03 ),(UINT16)portbit);
		pX0HB_EP1_BUF[ 0 ] = portbit;
		pX0HB_EP1T_L = 0x01;
		pX0HB_EP1RES = pX0HB_EP1RES & ~MASK_UEP_X_RES | UEP_X_RES_ACK;  		/* ϴ */
		return( 0x00 );
	}
	else 
	{  
		/* uploading */
		for( i = 255; i != 0; i -- ) 
		{
			if( pUSBX0_IE & bUX_SIE_FREE ) 
			{
				/* wait USBX free */
				break;  
			}
		}
		pX0HB_EP1_BUF[ 0 ] |= portbit;  										/* append */
		return( 0x01 );
	}
}

/*******************************************************************************
* Function Name  : USBX_OneHub_EP1IntUp
* Description    : USBX豸ڹرжϺΪUSBXϴHUBж֪ͨ, 0#~3#豸
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
UINT8 USBX_OneHub_EP1IntUp( UINT8 pcx, UINT8 index, UINT8 status ) 
{
	UINT8  s;
	UINT8  portbit;

	if( PCx_Connect_CurStatus & ( 1 << pcx ) )
	{
		portbit = 0x01 << ( index + 1 );
		EA = 0;  					
		USBX_SEL = bUSBX_XSFR_OFS | bUSBX_XRAM_OFS | pcx;			  
		X0DevBitFlag[ index ] = status;
	   	
		/* ǰ˯Ȼ */
		if( PCx_SleepStatus[ pcx ] == 0x03 )
		{
			USBX_Hub_Wakeup( );
			mDelaymS( 50 );
		}

		/* ж */
		s = USBX_ThisHub_EP1IntUp( portbit );
		USBX_SEL = 0;
		EA = 1;
		return( s );
	}
	return( 0xFF );
}

/*******************************************************************************
* Function Name  : USBX_AllHub_EP1IntUp
* Description    : USBX豸ڹرжϺΪUSBXϴHUBж֪ͨ, 0#~3#豸
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void USBX_AllHub_EP1IntUp( UINT8 index, UINT8 status ) 
{
	UINT8  i, portbit;

	portbit = 0x01 << ( index + 1 );
	EA = 0;  					
	for( i = 0; i != DEX_USBX_NUM_MAX_4; i ++ ) 
	{
		USBX_SEL = bUSBX_XSFR_OFS | bUSBX_XRAM_OFS | i;			  
		X0DevBitFlag[ index ] = status;
		if( PCx_Connect_CurStatus & ( 1 << i ) )
		{
			/* ǰ˯Ȼ */
			if( PCx_SleepStatus[ i ] == 0x03 )
			{
				USBX_Hub_Wakeup( );
				mDelaymS( 50 );
			}

			/* ж */
			USBX_ThisHub_EP1IntUp( portbit );
		}
	}
	USBX_SEL = 0;
	EA = 1;
}

#pragma	nomodp2
/*******************************************************************************
* Function Name  : USBX_DeviceInterrupt
* Description    : USBX豸жϷ,ʹüĴ1
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void USBX_DeviceInterrupt( void ) interrupt INT_NO_USBX using 1	
{
	UINT8  us;
	UINT16 len; 
	UINT8  rrd0, rrhb, rrhbc;
	UINT8  PortIndex;
	UINT8  i;
	UINT8  save;

USBX_DevIntNext:
//	if ( ( USBX_INT & ( bUSBX0_INT_ACT | bUSBX1_INT_ACT | bUSBX2_INT_ACT | bUSBX3_INT_ACT ) ) == 0 ) return;

	/* USBXԶƫ,ͨUSBX0дUSBX0-USBX3 */
	save = USBX_SEL;

	us = USBX_SEL = bUSBX_XSFR_OFS | bUSBX_XRAM_OFS | USBX_INT & ( MASK_UX_PC_ID | MASK_UX_DEV_ID ); 
	switch( us & MASK_UX_DEV_ID ) 
	{  
		case 0: 
			/*************************************************************************/ 
			/* sub-device 0# */
			
			/* STEUP,ֹһSTALL,һ */
 			if( ( pX0D0_STATUS & ( bUXS_SETUP_ACT | MASK_UXS_TOKEN ) ) == ( bUXS_SETUP_ACT | MASK_UXS_TOKEN ) )	
			{
				/* ˵0# SETUP */
				/* ӴξǰһSTALLһ޷ */
				pX0D0_EP0RES = bUEP_R_TOG | bUEP_T_TOG | UEP_R_RES_ACK | UEP_T_RES_NAK;  

				/* SETUPд */
				X0D0SetupLen = pX0D0_SETUP_REQ->wLengthL + ((UINT16)pX0D0_SETUP_REQ->wLengthH << 8 );
				len = 0;  														/* ĬΪɹϴ0 */
				if( ( pX0D0_SETUP_REQ->bRequestType & USB_REQ_TYP_MASK ) == USB_REQ_TYP_STANDARD ) 
				{  
					/* ׼ */
//					printf("0#: %02x-%02x-%02x-%02x\n",(UINT16)pX0D0_SETUP_REQ->bRequestType,
//								    				   (UINT16)pX0D0_SETUP_REQ->bRequest,
//									    			   (UINT16)pX0D0_SETUP_REQ->wValueL,
//										    		   (UINT16)pX0D0_SETUP_REQ->wValueH);

					X0D0SetupReqCode = pX0D0_SETUP_REQ->bRequest;
					switch( X0D0SetupReqCode ) 
					{  
						/*  */
						case USB_GET_DESCRIPTOR:
							switch( pX0D0_SETUP_REQ->wValueH ) 
							{
								case USB_DESCR_TYP_DEVICE:  
									/* 豸 */
									X0D0pDescr = &USBD_AllDesc_Buf[ USBD_Desc[ 0 ].Dev_Offset ];
									len = USBD_Desc[ 0 ].Dev_Len;
									break;

								case USB_DESCR_TYP_CONFIG:  
									/*  */
									X0D0pDescr = &USBD_AllDesc_Buf[ USBD_Desc[ 0 ].Cfg_Offset ];
									len = USBD_Desc[ 0 ].Cfg_Len;
									break;

								case USB_DESCR_TYP_STRING:  
									/* ַ */
									if( pX0D0_SETUP_REQ->wValueL == 0 )
									{
										X0D0pDescr = (PUINT8)( &cHubLangDescr[0] );
										len = sizeof( cHubLangDescr );											
									}
									else if( pX0D0_SETUP_REQ->wValueL == USBD_AllDesc_Buf[ USBD_Desc[ 0 ].Base_Offset + 14 ] )
									{
										X0D0pDescr = &USBD_AllDesc_Buf[ USBD_Desc[ 0 ].Str1_Offset ];
										len = USBD_Desc[ 0 ].Str1_Len;											
									}
									else if( pX0D0_SETUP_REQ->wValueL == USBD_AllDesc_Buf[ USBD_Desc[ 0 ].Base_Offset + 15 ] )
									{
										X0D0pDescr = &USBD_AllDesc_Buf[ USBD_Desc[ 0 ].Str2_Offset ];
										len = USBD_Desc[ 0 ].Str2_Len;											
									}
									else if( pX0D0_SETUP_REQ->wValueL == USBD_AllDesc_Buf[ USBD_Desc[ 0 ].Base_Offset + 16 ] )
									{
										X0D0pDescr = &USBD_AllDesc_Buf[ USBD_Desc[ 0 ].Str3_Offset ];
										len = USBD_Desc[ 0 ].Str3_Len;											
									}
									else if( pX0D0_SETUP_REQ->wValueL == USBD_AllDesc_Buf[ USBD_Desc[ 0 ].Cfg_Offset + 6 ] )
									{
										X0D0pDescr = &USBD_AllDesc_Buf[ USBD_Desc[ 0 ].Str4_Offset ];
										len = USBD_Desc[ 0 ].Str4_Len;											
									}
									else
									{
										/* ֵַ֧ */	
										len = 0xFFFF; 
									}
									break;

								case USB_DESCR_TYP_HID:  
									/* HID */
									len = 0xFFFF; 
									break;

								case USB_DESCR_TYP_REPORT:  
									/*  */
									switch( pX0D0_SETUP_REQ->wIndexL ) 
									{
										case 0:
											X0D0pDescr = &USBD_AllDesc_Buf[ USBD_Desc[ 0 ].Hid1_Offset ];
											len = USBD_Desc[ 0 ].Hid1_Len;
											break;
											
										case 1:
											X0D0pDescr = &USBD_AllDesc_Buf[ USBD_Desc[ 0 ].Hid2_Offset ];
											len = USBD_Desc[ 0 ].Hid2_Len;	
											break;
											
										case 2:
											X0D0pDescr = &USBD_AllDesc_Buf[ USBD_Desc[ 0 ].Hid3_Offset ];
											len = USBD_Desc[ 0 ].Hid3_Len;
											break;

										case 3:
											X0D0pDescr = &USBD_AllDesc_Buf[ USBD_Desc[ 0 ].Hid4_Offset ];
											len = USBD_Desc[ 0 ].Hid4_Len;
											break;

										case 4:
											X0D0pDescr = &USBD_AllDesc_Buf[ USBD_Desc[ 0 ].Hid5_Offset ];
											len = USBD_Desc[ 0 ].Hid5_Len;
											break;
											
										default:
											/* ֵַ֧ */	
											len = 0xFFFF;  
											break;
									}
									break;

								case USB_DESCR_TYP_PHYSIC:  
									/*  */
									len = 0xFFFF; 
									break;

								default:
									/* ֵ֧ */
									len = 0xFFFF;  
									break;
							}
							if( len != 0xFFFF ) 
							{
								if( X0D0SetupLen > len )
								{	 
									X0D0SetupLen = len;  						/* ܳ */
								}
								len = X0D0SetupLen >= EP0_PACKET_SIZE ? EP0_PACKET_SIZE : X0D0SetupLen;  /* δ䳤 */
								X0D0SetupLen -= len;
								memcpy( pX0D0_EP0_BUF, X0D0pDescr, len );   	/* ϴ */
								X0D0pDescr += len;
							}
							break;

						case USB_SET_ADDRESS:
							X0D0SetupLen = pX0D0_SETUP_REQ->wValueL;  			/* ݴUSB豸ַ */
							break;

						case USB_GET_CONFIGURATION:
							if( X0D0SetupLen ) 
							{
								len = 1;  
							}
							pX0D0_EP0_BUF[ 0 ] = X0D0UsbConfig;
							break;

						case USB_SET_CONFIGURATION:
							USBX0_Dev0_Init( 0 );
							X0D0UsbConfig = pX0D0_SETUP_REQ->wValueL;
							break;

						case USB_CLEAR_FEATURE:
							if( pX0D0_SETUP_REQ->bRequestType == ( USB_REQ_TYP_STANDARD | USB_REQ_RECIP_ENDP ) ) 
							{  
								/* Ŀ:˵ */
								if( pX0D0_SETUP_REQ->wValueL == 0 ) 
								{  
									/* ENDPOINT_HALT */
									switch( pX0D0_SETUP_REQ->wIndexL ) 
									{
										case 0x03:  
											/* endpoint 3# ˵´ */
											pX0D0_EP3RES = pX0D0_EP3RES & ~( bUEP_X_TOG | MASK_UEP_X_RES ) | UEP_X_RES_ACK;
											break;
											
										case 0x82:  
											/* endpoint 2# ˵ϴ */
											pX0D0_EP2RES = pX0D0_EP2RES & ~( bUEP_X_TOG | MASK_UEP_X_RES ) | UEP_X_RES_NAK;
											break;
											
										case 0x81:  
											/* endpoint 1# ˵ϴ */
											pX0D0_EP1RES = pX0D0_EP1RES & ~( bUEP_X_TOG | MASK_UEP_X_RES ) | UEP_X_RES_NAK;
											break;
											
										default:
											/* ֵ֧Ķ˵ */
											len = 0xFFFF;  
										break;
									}
								}
								else len = 0xFFFF;
							}
							else 
							{  
								/* Ƕ˵ */
								len = 0xFF; 
							}
							break;

						case USB_GET_INTERFACE:
							if( X0D0SetupLen )
							{ 
								len = 1;  										/* Ƴ */
							}
							pX0D0_EP0_BUF[ 0 ] = 0x00;
							break;

						case USB_GET_STATUS:  
							if( X0D0SetupLen >= 2 ) 
							{
								len = 2;  										/* Ƴ */
							}
							else
							{	 
								len = X0D0SetupLen;
							}
							rrd0 = pX0D0_SETUP_REQ->bRequestType & USB_REQ_RECIP_MASK;
							if( rrd0 == USB_REQ_RECIP_DEVICE ) 
							{
								pX0D0_EP0_BUF[ 0 ] = 0x01;
							}
							else if( rrd0 == USB_REQ_RECIP_INTERF )
							{	 
								pX0D0_EP0_BUF[ 0 ] = 0x00;
							}
							else if( rrd0 == USB_REQ_RECIP_ENDP ) 
							{
								pX0D0_EP0_BUF[ 0 ] = ( ( pX0D0_SETUP_REQ->wIndexL == 0x81 ? pX0D0_EP1RES
																						: ( pX0D0_SETUP_REQ->wIndexL == 0x82 ? pX0D0_EP2RES
																						: ( pX0D0_SETUP_REQ->wIndexL == 0x03 ? pX0D0_EP3RES : 0x00 ) ) ) & MASK_UEP_X_RES ) == UEP_X_RES_STALL ? 0x01 : 0x00;  // ???
							}
							else
							{ 
								pX0D0_EP0_BUF[ 0 ] = 0x00;
							}
							pX0D0_EP0_BUF[ 1 ] = 0x00;
							break;

						case USB_SET_FEATURE: 
							if( ( pX0D0_SETUP_REQ->bRequestType & 0x1F ) == 0x00 )                 
							{                        	
                    			/* 豸 */	
								if( ( ( ( UINT16 )pX0D0_SETUP_REQ->wValueH << 8 ) | pX0D0_SETUP_REQ->wValueL ) == 0x01 )
								{
                        			if( cHubCfgDescr[ 7 ] & 0x20 )
                        			{
                             			/* ûʹܱ־ */
										PCx_SleepStatus[ us & 0x03 ] |= 0x01;
                        			}
                        			else
                        			{
                            			len = 0xFFFF;                       /* ʧ */
                        			}
                      			}
								else
								{
									len = 0xFFFF;                           /* ʧ */
								}
							}
							else if( ( pX0D0_SETUP_REQ->bRequestType & 0x1F ) == 0x02 )             
							{
								/* ö˵ */
								if( ( ( ( UINT16 )pX0D0_SETUP_REQ->wValueH << 8 ) | pX0D0_SETUP_REQ->wValueL ) == 0x00 )
								{
									switch( ( ( UINT16 )pX0D0_SETUP_REQ->wIndexH << 8 ) | pX0D0_SETUP_REQ->wIndexL )
									{
										case 0x81:
											/* ö˵1 IN STALL */
											UEP1_CTRL = UEP1_CTRL & (~bUEP_T_TOG) | UEP_T_RES_STALL;
											break;

										default:
											len = 0xFFFF;                   /* ʧ */
											break;
									}
								}
								else
								{
									len = 0xFFFF;                           /* ʧ */
								}
							}
							else
							{
								len = 0xFFFF;                               /* ʧ */
							}
							
						default:
							len = 0xFFFF;  										/* ʧ  */
							break;
					}
				}
				else if( ( pX0D0_SETUP_REQ->bRequestType & USB_REQ_TYP_MASK ) == USB_REQ_TYP_CLASS ) 
				{  
					/*  */
					X0D0SetupReqCode = pX0D0_SETUP_REQ->bRequest;
					switch( X0D0SetupReqCode ) 
					{  
						/*  */
						case HID_GET_REPORT:
                            memcpy( pSetupReq, pX0D0_SETUP_REQ , 8);                                 /* ·GetReport */
                            len = X0D0SetupLen;
                            if( len > 128 )
                            {
                                len = X0D0SetupLen = 128;
                            }
                            USBH_CtrlTransfer( &Sp_SetReport_Pack, &len );
                            X0D0pDescr = Sp_SetReport_Pack;
                            len = X0D0SetupLen >= EP0_PACKET_SIZE ? EP0_PACKET_SIZE : X0D0SetupLen;  /* δ䳤 */
                            X0D0SetupLen -= len;
                            memcpy( pX0D0_EP0_BUF, X0D0pDescr, len );   	/* ϴ */
                            X0D0pDescr += len;
							break;

						case HID_SET_REPORT:
							/* 浱ǰӦĽӿںż */
							Sp_SetReport_Value = pX0D0_SETUP_REQ->wValueH;
                            Sp_SetReport_Index = pX0D0_SETUP_REQ->wIndexL;
							Sp_SetReport_Len = pX0D0_SETUP_REQ->wLengthL;
							if( Sp_SetReport_Len > 128 )
							{
								Sp_SetReport_Len = 128;
							}
                            Sp_SetReport_SaveLen = Sp_SetReport_Len;
							break;

						case HID_GET_IDLE:
							if( X0D0SetupLen )
							{ 
								len = 1;  
							}
							pX0D0_EP0_BUF[ 0 ] = 0x00;  						/* ʱ */
							break;

						case HID_SET_IDLE:
//								= pX0D0_EP0_BUF[3];  							/* ʱ */
							break;

						case HID_GET_PROTOCOL:
							if( X0D0SetupLen )
							{ 
								len = 1;  
							}
							pX0D0_EP0_BUF[ 0 ] = X0D0_PROTOCOL;  				/* Э־ */
							break;

						case HID_SET_PROTOCOL:
							X0D0_PROTOCOL = pX0D0_EP0_BUF[ 2 ];  				/* Э־ */
							break;

						default:
							/* ʧ */
							len = 0xFFFF;  
							break;
					}
				}
				else 
				{  
					/* ֱֻ֧׼ */
					len = 0xFFFF;  												/* ʧ */
				}

				if( len == 0xFFFF ) 
				{  
					/* ʧ */
					X0D0SetupReqCode = 0xFF;
					pX0D0_EP0RES = bUEP_R_TOG | bUEP_T_TOG | UEP_R_RES_STALL | UEP_T_RES_STALL;  /* STALL */
				}
				else if( len <= EP0_PACKET_SIZE ) 
				{  
					/* ϴݻ״̬׶η0Ȱ */
					pX0D0_EP0T_L = len;
					pX0D0_EP0RES = bUEP_R_TOG | bUEP_T_TOG | UEP_R_RES_ACK | UEP_T_RES_ACK;  /* ĬݰDATA1 */
				}
				else 
				{  
					/* ´ݻ */
					pX0D0_EP0T_L = 0;  /* Ȼδ״̬׶ΣǰԤϴ0ݰԷǰ״̬׶ */
					pX0D0_EP0RES = bUEP_R_TOG | bUEP_T_TOG | UEP_R_RES_ACK | UEP_T_RES_ACK;  /* ĬݰDATA1 */
				}
			}
			else
			{
				switch( pX0D0_STATUS & ( bUXS_SETUP_ACT | MASK_UXS_TOKEN | MASK_UXS_ENDP ) ) 
				{  
					/* ƺͶ˵ */
					case UXS_TOKEN_IN | 1:  
					case bUXS_SETUP_ACT | UXS_TOKEN_IN | 1:
						/* ˵1# ˵ϴ */
						pX0D0_EP1RES ^= bUEP_X_TOG;
						pX0D0_EP1RES = pX0D0_EP1RES & ~MASK_UEP_X_RES | UEP_X_RES_NAK; /* ͣϴ */

						/* HIDϴ־ */
						PCx_HidUpStatus[ us & 0x03 ][ 0 ] = 0x00;	
						break;
	
					case UXS_TOKEN_IN | 2:  
					case bUXS_SETUP_ACT | UXS_TOKEN_IN | 2:
						/* ˵2# ˵ϴ */
						pX0D0_EP2RES ^= bUEP_X_TOG;
						pX0D0_EP2RES = pX0D0_EP2RES & ~MASK_UEP_X_RES | UEP_X_RES_NAK; /* ͣϴ */

						/* HIDϴ־ */
						PCx_HidUpStatus[ us & 0x03 ][ 0 ] = 0x00;
						break;
	
					case UXS_TOKEN_IN | 3:  
					case bUXS_SETUP_ACT | UXS_TOKEN_IN | 3:
						/* ˵3# ˵ϴ */
						pX0D0_EP3RES ^= bUEP_X_TOG;
						pX0D0_EP3RES = pX0D0_EP3RES & ~MASK_UEP_X_RES | UEP_X_RES_NAK; /* ͣϴ */

						/* HIDϴ־ */
						PCx_HidUpStatus[ us & 0x03 ][ 0 ] = 0x00;
						break;
	
					case UXS_TOKEN_IN | 4:  
					case bUXS_SETUP_ACT | UXS_TOKEN_IN | 4:
						/* ˵4# ˵ϴ */
						pX0D0_EP4RES ^= bUEP_X_TOG;
						pX0D0_EP4RES = pX0D0_EP4RES & ~MASK_UEP_X_RES | UEP_X_RES_NAK; /* ͣϴ */

						/* HIDϴ־ */
						PCx_HidUpStatus[ us & 0x03 ][ 0 ] = 0x00;
						break;
	
					case UXS_TOKEN_IN | 5:  
					case bUXS_SETUP_ACT | UXS_TOKEN_IN | 5:
						/* ˵5# ˵ϴ */
						pX0D0_EP5RES ^= bUEP_X_TOG;
						pX0D0_EP5RES = pX0D0_EP5RES & ~MASK_UEP_X_RES | UEP_X_RES_NAK; /* ͣϴ */

						/* HIDϴ־ */
						PCx_HidUpStatus[ us & 0x03 ][ 0 ] = 0x00;
						break;
	
					case UXS_TOKEN_IN | 6:  
					case bUXS_SETUP_ACT | UXS_TOKEN_IN | 6:
						/* ˵6# ˵ϴ */
						pX0D0_EP6RES ^= bUEP_X_TOG;
						pX0D0_EP6RES = pX0D0_EP6RES & ~MASK_UEP_X_RES | UEP_X_RES_NAK; /* ͣϴ */

						/* HIDϴ־ */
						PCx_HidUpStatus[ us & 0x03 ][ 0 ] = 0x00;
						break;
	
					case UXS_TOKEN_IN | 0:  
					case bUXS_SETUP_ACT | UXS_TOKEN_IN | 0:
						/* ˵0# IN */
						switch( X0D0SetupReqCode ) 
						{
                            case HID_GET_REPORT:
                            case USB_GET_DESCRIPTOR:
								len = X0D0SetupLen >= EP0_PACKET_SIZE ? EP0_PACKET_SIZE : X0D0SetupLen;  /* δ䳤 */
								X0D0SetupLen -= len;
								memcpy( pX0D0_EP0_BUF, X0D0pDescr, len );  		/* ϴ */
								X0D0pDescr += len;
								pX0D0_EP0T_L = len;
								pX0D0_EP0RES ^= bUEP_T_TOG;  					/* ת */
								break;
								
							case USB_SET_ADDRESS:
								pX0D0_ADDR = X0D0SetupLen;
								pX0D0_EP0RES = UEP_R_RES_ACK | UEP_T_RES_NAK;
								break;
								
							default:
								pX0D0_EP0T_L = 0;  								/* ״̬׶жϻǿϴ0ݰƴ */
								pX0D0_EP0RES = UEP_R_RES_ACK | UEP_T_RES_NAK;
								break;
						}
						break;
	
					case UXS_TOKEN_OUT | 0:  
					case bUXS_SETUP_ACT | UXS_TOKEN_OUT | 0:
						/* ˵0# OUT */
						switch( X0D0SetupReqCode ) 
						{
						   case 0x09:	
								/* ̵ */

								/* жǰӿǼΪ̵ƿ,Ϊ¼,Ҫ͸ */
								if( ( HostCtl[ 0 ].Interface[ ( Sp_SetReport_Index & 0x0F ) ].Type == DEC_KEY ) && 
								    ( Sp_SetReport_Len <= 2 ) )
								{
									/* 浱ǰָʾֵ */
									if( HostCtl[ 0 ].Interface[ ( Sp_SetReport_Index & 0x0F ) ].HidReportID &&
										( HostCtl[ 0 ].Interface[ ( Sp_SetReport_Index & 0x0F ) ].HidReportID == pX0D0_EP0_BUF[ 0 ] ) )
									{
										PCx_KBSetReport[ us & 0x03 ] = pX0D0_EP0_BUF[ 1 ];
									}
									else
									{
										PCx_KBSetReport[ us & 0x03 ] = pX0D0_EP0_BUF[ 0 ];
									}
									Sp_SetReport_Len = 0x00;
								}
								else
								{
									if( Sp_SetReport_SaveLen > 64 )
                                    {
                                        memcpy( Sp_SetReport_Pack, pX0D0_EP0_BUF, 64 );
                                        Sp_SetReport_SaveLen -= 64;
                                    }
                                    else
                                    {
                                        memcpy( &Sp_SetReport_Pack[ Sp_SetReport_Len - Sp_SetReport_SaveLen ], pX0D0_EP0_BUF, Sp_SetReport_SaveLen );
                                        Sp_SetReport_Len |= 0x80;
                                    }			
								}
	 							pX0D0_EP0T_L = 0;
								pX0D0_EP0RES = bUEP_R_TOG | bUEP_T_TOG | UEP_R_RES_ACK | UEP_T_RES_ACK;  /* ĬݰDATA1 */
								break;
	
							case USB_GET_DESCRIPTOR:
							default:
								if( pX0D0_STATUS & bUXS_TOG_OK ) 
								{  
									/* ͬݰ  */
	//								if ( pX0D0_RX_LEN ) control_status_error;
	//								else control_ok;  // յ0Ȱʾƶ/ϴOK */
								}
	//							else control_status_error;
								pX0D0_EP0RES = UEP_R_RES_ACK | UEP_T_RES_NAK;  	/* ׼һƴ */
								break;
						}
						break;
						
					default:
	//					printf("ErrEndpInt\n");
						break;
				}

			}
			UIF_USBX_IF = 0;  													/* жϱ־ */
			break;
		
		case bUSBX_DEV_ID0:  
			/*************************************************************************/ 
			/* sub-device 1# */
			/* STEUP,ֹһSTALL,һ */
			if( ( pX0D1_STATUS & ( bUXS_SETUP_ACT | MASK_UXS_TOKEN ) ) == ( bUXS_SETUP_ACT | MASK_UXS_TOKEN ) )
			{
				/* ˵0# SETUP */
				
				/* ӴξǰһSTALLһ޷ */
				pX0D1_EP0RES = bUEP_R_TOG | bUEP_T_TOG | UEP_R_RES_ACK | UEP_T_RES_NAK;  

				X0D1SetupLen = pX0D1_SETUP_REQ->wLengthL + ((UINT16)pX0D1_SETUP_REQ->wLengthH << 8 );
				len = 0;  														/* ĬΪɹϴ0 */
				if( ( pX0D1_SETUP_REQ->bRequestType & USB_REQ_TYP_MASK ) == USB_REQ_TYP_STANDARD ) 
				{  
					/* ׼ */
//					printf("1#: %02x-%02x-%02x-%02x\n",(UINT16)pX0D1_SETUP_REQ->bRequestType,
//								    				   (UINT16)pX0D1_SETUP_REQ->bRequest,
//									    			   (UINT16)pX0D1_SETUP_REQ->wValueL,
//										    		   (UINT16)pX0D1_SETUP_REQ->wValueH);
																			     
					X0D1SetupReqCode = pX0D1_SETUP_REQ->bRequest;
					switch( X0D1SetupReqCode ) 
					{  
						/*  */
						case USB_GET_DESCRIPTOR:
							switch( pX0D1_SETUP_REQ->wValueH ) 
							{
								case USB_DESCR_TYP_DEVICE:  
									/* 豸 */
									X0D1pDescr = &USBD_AllDesc_Buf[ USBD_Desc[ 1 ].Dev_Offset ];
									len = USBD_Desc[ 1 ].Dev_Len;
									break;
									
								case USB_DESCR_TYP_CONFIG:  
									/*  */
									X0D1pDescr = &USBD_AllDesc_Buf[ USBD_Desc[ 1 ].Cfg_Offset ];
									len = USBD_Desc[ 1 ].Cfg_Len;
									break;
									
								case USB_DESCR_TYP_STRING:  
									/* ַ */
									if( pX0D1_SETUP_REQ->wValueL == 0 )
									{
										X0D1pDescr = (PUINT8)( &cHubLangDescr[0] );
										len = sizeof( cHubLangDescr );											
									}
									else if( pX0D1_SETUP_REQ->wValueL == USBD_AllDesc_Buf[ USBD_Desc[ 1 ].Base_Offset + 14 ] )
									{
										X0D1pDescr = &USBD_AllDesc_Buf[ USBD_Desc[ 1 ].Str1_Offset ];
										len = USBD_Desc[ 1 ].Str1_Len;											
									}
									else if( pX0D1_SETUP_REQ->wValueL == USBD_AllDesc_Buf[ USBD_Desc[ 1 ].Base_Offset + 15 ] )
									{
										X0D1pDescr = &USBD_AllDesc_Buf[ USBD_Desc[ 1 ].Str2_Offset ];
										len = USBD_Desc[ 1 ].Str2_Len;											
									}
									else if( pX0D1_SETUP_REQ->wValueL == USBD_AllDesc_Buf[ USBD_Desc[ 1 ].Base_Offset + 16 ] )
									{
										X0D1pDescr = &USBD_AllDesc_Buf[ USBD_Desc[ 1 ].Str3_Offset ];
										len = USBD_Desc[ 1 ].Str3_Len;											
									}
									else if( pX0D1_SETUP_REQ->wValueL == USBD_AllDesc_Buf[ USBD_Desc[ 1 ].Cfg_Offset + 6 ] )
									{
										X0D1pDescr = &USBD_AllDesc_Buf[ USBD_Desc[ 1 ].Str4_Offset ];
										len = USBD_Desc[ 1 ].Str4_Len;											
									}
									else
									{
										/* ֵַ֧ */	
										len = 0xFFFF; 
									}
									break;
									
								case USB_DESCR_TYP_HID:  
									/* HID */
									len = 0xFFFF;
									break;
									
								case USB_DESCR_TYP_REPORT:  
									/* HID */
									switch( pX0D1_SETUP_REQ->wIndexL ) 
									{
										case 0:
											X0D1pDescr = &USBD_AllDesc_Buf[ USBD_Desc[ 1 ].Hid1_Offset ];
											len = USBD_Desc[ 1 ].Hid1_Len;
											break;
											
										case 1:
											X0D1pDescr = &USBD_AllDesc_Buf[ USBD_Desc[ 1 ].Hid2_Offset ];
											len = USBD_Desc[ 1 ].Hid2_Len;	
											break;
											
										case 2:
											X0D1pDescr = &USBD_AllDesc_Buf[ USBD_Desc[ 1 ].Hid3_Offset ];
											len = USBD_Desc[ 1 ].Hid3_Len;
											break;

										case 3:
											X0D1pDescr = &USBD_AllDesc_Buf[ USBD_Desc[ 1 ].Hid4_Offset ];
											len = USBD_Desc[ 1 ].Hid4_Len;
											break;

										case 4:
											X0D1pDescr = &USBD_AllDesc_Buf[ USBD_Desc[ 1 ].Hid5_Offset ];
											len = USBD_Desc[ 1 ].Hid5_Len;
											break;
											
										default:
											/* ֵַ֧ */	
											len = 0xFFFF;  
											break;
									}
									break;
									
								case USB_DESCR_TYP_PHYSIC:  
									/*  */
									len = 0xFFFF; 
									break;
									
								default:
									/* ֵ֧ */	
									len = 0xFFFF;  
									break;
							}
							if( len != 0xFFFF ) 
							{
								if( X0D1SetupLen > len )
								{ 
									X0D1SetupLen = len;  						/* ܳ */
								}
								len = X0D1SetupLen >= EP0_PACKET_SIZE ? EP0_PACKET_SIZE : X0D1SetupLen;  /* δ䳤 */
								X0D1SetupLen -= len;
								memcpy( pX0D1_EP0_BUF, X0D1pDescr, len );  	 	/* ϴ */
								X0D1pDescr += len;
							}
							break;
							
						case USB_SET_ADDRESS:
							X0D1SetupLen = pX0D1_SETUP_REQ->wValueL;  			/* ݴUSB豸ַ */
							break;
							
						case USB_GET_CONFIGURATION:
							if( X0D1SetupLen )
							{ 
								len = 1;  										/* Ƴ */
							}
							pX0D1_EP0_BUF[ 0 ] = X0D1UsbConfig;
							break;
							
						case USB_SET_CONFIGURATION:
							USBX0_Dev1_Init( 0 );
							X0D1UsbConfig = pX0D1_SETUP_REQ->wValueL;
							break;
							
						case USB_CLEAR_FEATURE:
							if( pX0D1_SETUP_REQ->bRequestType == ( USB_REQ_TYP_STANDARD | USB_REQ_RECIP_ENDP ) ) 
							{  
								/* Ŀ:˵ */
								if( pX0D1_SETUP_REQ->wValueL == 0 ) 
								{  
									/* ENDPOINT_HALT */
									switch( pX0D1_SETUP_REQ->wIndexL )
									{
										case 0x03:  
											/* endpoint 3# ˵´ */
											pX0D1_EP3RES = pX0D1_EP3RES & ~ ( bUEP_X_TOG | MASK_UEP_X_RES ) | UEP_X_RES_ACK;
											break;
											
										case 0x82:  
											/* endpoint 2# ˵ϴ */
											pX0D1_EP2RES = pX0D1_EP2RES & ~ ( bUEP_X_TOG | MASK_UEP_X_RES ) | UEP_X_RES_NAK;
											break;
											
										case 0x81:  
											/* endpoint 1# ˵ϴ	*/
											pX0D1_EP1RES = pX0D1_EP1RES & ~ ( bUEP_X_TOG | MASK_UEP_X_RES ) | UEP_X_RES_NAK;
											break;
											
										default:
											/* ֵ֧Ķ˵ */
											len = 0xFFFF;  
										break;
									}
								}
								else 
								{
									len = 0xFFFF;
								}
							}
							else 
							{  
								/* Ƕ˵ */
								len = 0xFFFF;
							}
							break;
							
						case USB_GET_INTERFACE:
							if( X0D1SetupLen ) 
							{	
								len = 1;  								
							}
							pX0D1_EP0_BUF[ 0 ] = 0x00;
							break;
						case USB_GET_STATUS:  
							if( X0D1SetupLen >= 2 ) 
							{
								len = 2;  
							}	
							else 
							{
								len = X0D1SetupLen;
							}
							rrd0 = pX0D1_SETUP_REQ->bRequestType & USB_REQ_RECIP_MASK;
							if( rrd0 == USB_REQ_RECIP_DEVICE ) 
							{
								pX0D1_EP0_BUF[ 0 ] = 0x01;
							}
							else if( rrd0 == USB_REQ_RECIP_INTERF )
							{	 
								pX0D1_EP0_BUF[ 0 ] = 0x00;
							}
							else if( rrd0 == USB_REQ_RECIP_ENDP ) 
							{
								pX0D1_EP0_BUF[ 0 ] = ( ( pX0D1_SETUP_REQ->wIndexL == 0x81 ? pX0D1_EP1RES
												     : ( pX0D1_SETUP_REQ->wIndexL == 0x82 ? pX0D1_EP2RES
												     : ( pX0D1_SETUP_REQ->wIndexL == 0x03 ? pX0D1_EP3RES : 0x00 ) ) ) & MASK_UEP_X_RES ) == UEP_X_RES_STALL ? 0x01 : 0x00;  // ???
							}
							else 
							{
								pX0D1_EP0_BUF[ 0 ] = 0x00;
							}
							pX0D1_EP0_BUF[ 1 ] = 0x00;
							break;
							
						case USB_SET_FEATURE:  
						default:
							/* ʧ */	
							len = 0xFFFF;  
							break;
					}
				}
				else if( ( pX0D1_SETUP_REQ->bRequestType & USB_REQ_TYP_MASK ) == USB_REQ_TYP_CLASS ) 
				{  
					/*  */
					X0D1SetupReqCode = pX0D1_SETUP_REQ->bRequest;
					switch( X0D1SetupReqCode ) 
					{  
						/*  */
						case HID_GET_REPORT:
                            memcpy( pSetupReq, pX0D1_SETUP_REQ , 8 );                                 /* ·GetReport */
                            len = X0D1SetupLen;
                            if( len > 128 )
                            {
                                len = X0D1SetupLen = 128;
                            }
                            USBH_CtrlTransfer( &Sp_SetReport_Pack, &len );
                            X0D1pDescr = Sp_SetReport_Pack;
                            len = X0D1SetupLen >= EP0_PACKET_SIZE ? EP0_PACKET_SIZE : X0D1SetupLen;  /* δ䳤 */
                            X0D1SetupLen -= len;
                            memcpy( pX0D1_EP0_BUF, X0D1pDescr, len );   	/* ϴ */
                            X0D1pDescr += len;
                            break;
							
						case HID_SET_REPORT:
							/* 浱ǰӦĽӿںż */
                            Sp_SetReport_Value = pX0D1_SETUP_REQ->wValueH;
                            Sp_SetReport_Index = 0x10 | pX0D1_SETUP_REQ->wIndexL;
							Sp_SetReport_Len = pX0D1_SETUP_REQ->wLengthL;
							if( Sp_SetReport_Len > 128 )
							{
								Sp_SetReport_Len = 128;
							}
                            Sp_SetReport_SaveLen = Sp_SetReport_Len;
							break;
							
						case HID_GET_IDLE:
							if( X0D1SetupLen ) 
							{	
								len = 1;  
							}	
							pX0D1_EP0_BUF[0] = 0x00;  							/* ʱ */
							break;
							
						case HID_SET_IDLE:
//								= pX0D1_EP0_BUF[3];  							/* ʱ */
							break;
							
						case HID_GET_PROTOCOL:
							if( X0D1SetupLen ) 
							{	
								len = 1;  
							}	
							pX0D1_EP0_BUF[ 0 ] = X0D1_PROTOCOL;  				/* Э־ */
							break;
							
						case HID_SET_PROTOCOL:
							X0D1_PROTOCOL = pX0D1_EP0_BUF[ 2 ];  				/* Э־ */
							break;
							
						default:
							/* ʧ */
							len = 0xFFFF;  
							break;
					}
				}
				else 
				{  
					/* ֱֻ֧׼/ */
					/* ʧ */
					len = 0xFFFF;  
//					printf("ErrEp0ReqType=%02X\n",(UINT16)pX0D1_SETUP_REQ->bRequestType);
				}
				if( len == 0xFFFF ) 
				{  
					/* ʧ */
					X0D1SetupReqCode = 0xFF;
					pX0D1_EP0RES = bUEP_R_TOG | bUEP_T_TOG | UEP_R_RES_STALL | UEP_T_RES_STALL;  /* STALL */
				}
				else if( len <= EP0_PACKET_SIZE ) 
				{  
					/* ϴݻ״̬׶η0Ȱ */
					pX0D1_EP0T_L = len;
					pX0D1_EP0RES = bUEP_R_TOG | bUEP_T_TOG | UEP_R_RES_ACK | UEP_T_RES_ACK;  /* ĬݰDATA1 */
				}
				else 
				{  /* ´ݻ */
					pX0D1_EP0T_L = 0;  /* Ȼδ״̬׶ΣǰԤϴ0ݰԷǰ״̬׶ */
					pX0D1_EP0RES = bUEP_R_TOG | bUEP_T_TOG | UEP_R_RES_ACK | UEP_T_RES_ACK;  /*/ ĬݰDATA1 */
				}
			}
			else
			{
				switch( pX0D1_STATUS & ( bUXS_SETUP_ACT | MASK_UXS_TOKEN | MASK_UXS_ENDP ) ) 
				{  
					/* ƺͶ˵ */	
					case UXS_TOKEN_IN | 1:  
					case bUXS_SETUP_ACT | UXS_TOKEN_IN | 1:
						/* ˵1# ˵ϴ */
						pX0D1_EP1RES ^= bUEP_X_TOG;
						pX0D1_EP1RES = pX0D1_EP1RES & ~MASK_UEP_X_RES | UEP_X_RES_NAK; 	/* ͣϴ */

						/* HIDϴ־ */
						PCx_HidUpStatus[ us & 0x03 ][ 1 ] = 0x00;
						break;
	
					case UXS_TOKEN_IN | 2:  
					case bUXS_SETUP_ACT | UXS_TOKEN_IN | 2:
						/* ˵2# ˵ϴ */
						pX0D1_EP2RES ^= bUEP_X_TOG;	
						pX0D1_EP2RES = pX0D1_EP2RES & ~MASK_UEP_X_RES | UEP_X_RES_NAK; 	/* ͣϴ */

						/* HIDϴ־ */
						PCx_HidUpStatus[ us & 0x03 ][ 1 ] = 0x00;
						break;
	
					case UXS_TOKEN_IN | 3:  
					case bUXS_SETUP_ACT | UXS_TOKEN_IN | 3:
						/* ˵3# ˵ϴ */
						pX0D1_EP3RES ^= bUEP_X_TOG;
						pX0D1_EP3RES = pX0D1_EP3RES & ~MASK_UEP_X_RES | UEP_X_RES_NAK;  /* ͣϴ */

						/* HIDϴ־ */
						PCx_HidUpStatus[ us & 0x03 ][ 1 ] = 0x00;
						break;
	
					case UXS_TOKEN_IN | 4:  
					case bUXS_SETUP_ACT | UXS_TOKEN_IN | 4:
						/* ˵4# ˵ϴ */
						pX0D1_EP4RES ^= bUEP_X_TOG;
						pX0D1_EP4RES = pX0D1_EP4RES & ~MASK_UEP_X_RES | UEP_X_RES_NAK;  /* ͣϴ */

						/* HIDϴ־ */
						PCx_HidUpStatus[ us & 0x03 ][ 1 ] = 0x00;
						break;
	
					case UXS_TOKEN_IN | 5:  
					case bUXS_SETUP_ACT | UXS_TOKEN_IN | 5:
						/* ˵5# ˵ϴ */
						pX0D1_EP5RES ^= bUEP_X_TOG;
						pX0D1_EP5RES = pX0D1_EP5RES & ~MASK_UEP_X_RES | UEP_X_RES_NAK;  /* ͣϴ */

						/* HIDϴ־ */
						PCx_HidUpStatus[ us & 0x03 ][ 1 ] = 0x00;
						break;
	
					case UXS_TOKEN_IN | 6:  
					case bUXS_SETUP_ACT | UXS_TOKEN_IN | 6:
						/* ˵6# ˵ϴ */
						pX0D1_EP6RES ^= bUEP_X_TOG;
						pX0D1_EP6RES = pX0D1_EP6RES & ~MASK_UEP_X_RES | UEP_X_RES_NAK;  /* ͣϴ */

						/* HIDϴ־ */
						PCx_HidUpStatus[ us & 0x03 ][ 1 ] = 0x00;
						break;				
						
					case UXS_TOKEN_IN | 0:  
					case bUXS_SETUP_ACT | UXS_TOKEN_IN | 0:
						/* ˵0# IN */
						switch( X0D1SetupReqCode ) 
						{
							case HID_GET_REPORT:
                            case USB_GET_DESCRIPTOR:
								len = X0D1SetupLen >= EP0_PACKET_SIZE ? EP0_PACKET_SIZE : X0D1SetupLen;  // δ䳤 */
								X0D1SetupLen -= len;
								memcpy( pX0D1_EP0_BUF, X0D1pDescr, len );  		/* ϴ */
								X0D1pDescr += len;
								pX0D1_EP0T_L = len;
								pX0D1_EP0RES ^= bUEP_T_TOG;  					/* ת */
								break;
								
							case USB_SET_ADDRESS:
								pX0D1_ADDR = X0D1SetupLen;
								pX0D1_EP0RES = UEP_R_RES_ACK | UEP_T_RES_NAK;
								break;
								
							default:
								pX0D1_EP0T_L = 0;  								/* ״̬׶жϻǿϴ0ݰƴ */
								pX0D1_EP0RES = UEP_R_RES_ACK | UEP_T_RES_NAK;
								break;
								
						}
						break;
						
					case UXS_TOKEN_OUT | 0:  
					case bUXS_SETUP_ACT | UXS_TOKEN_OUT | 0:
						/* endpoint 0# OUT */
						switch( X0D1SetupReqCode ) 
						{
						   case 0x09:
								/* ̵ */

								/* жǰӿǼΪ̵ƿ,Ϊ¼,Ҫ͸ */
								if( ( HostCtl[ 1 ].Interface[ ( Sp_SetReport_Index & 0x0F ) ].Type == DEC_KEY ) &&
								    ( Sp_SetReport_Len <= 2 ) )
								{
									/* 浱ǰָʾֵ */
									if( HostCtl[ 1 ].Interface[ ( Sp_SetReport_Index & 0x0F ) ].HidReportID &&
										( HostCtl[ 1 ].Interface[ ( Sp_SetReport_Index & 0x0F ) ].HidReportID == pX0D1_EP0_BUF[ 0 ] ) )
									{
										PCx_KBSetReport[ us & 0x03 ] = pX0D1_EP0_BUF[ 1 ];
									}
									else
									{
										PCx_KBSetReport[ us & 0x03 ] = pX0D1_EP0_BUF[ 0 ];
									}
									Sp_SetReport_Len = 0x00;
								}
                                else
								{
									if( Sp_SetReport_SaveLen > 64 )
                                    {
                                        memcpy( Sp_SetReport_Pack, pX0D1_EP0_BUF, 64 );
                                        Sp_SetReport_SaveLen -= 64;
                                    }
                                    else
                                    {
                                        memcpy( &Sp_SetReport_Pack[ Sp_SetReport_Len - Sp_SetReport_SaveLen ], pX0D1_EP0_BUF, Sp_SetReport_SaveLen );
                                        Sp_SetReport_Len |= 0x80;
                                    }			
								}
	 							pX0D1_EP0T_L = 0;
								pX0D1_EP0RES = bUEP_R_TOG | bUEP_T_TOG | UEP_R_RES_ACK | UEP_T_RES_ACK;  /* ĬݰDATA1 */
								break;
	
							case USB_GET_DESCRIPTOR:
							default:
								if ( pX0D1_STATUS & bUXS_TOG_OK ) 
								{  
									/* ͬݰ */
	//								if ( pX0D1_RX_LEN ) control_status_error;
	//								else control_ok;  // յ0Ȱʾƶ/ϴOK */
								}
	//							else control_status_error;
								pX0D1_EP0RES = UEP_R_RES_ACK | UEP_T_RES_NAK;   /* ׼һƴ */
								break;
						}
						break;
					default:
	//					printf("ErrEndpInt\n");
						break;
				}
			}
			UIF_USBX_IF = 0;  													/* жϱ־ */
			break;

		case bUSBX_DEV_ID1:  
			/*************************************************************************/ 
			/* sub-device 2# */
			/* STEUP,ֹһSTALL,һ */
			if( ( pX0D2_STATUS & ( bUXS_SETUP_ACT | MASK_UXS_TOKEN ) ) == ( bUXS_SETUP_ACT | MASK_UXS_TOKEN ) )
			{
				/* ˵0# SETUP */
				
				/* ӴξǰһSTALLһ޷ */
				pX0D2_EP0RES = bUEP_R_TOG | bUEP_T_TOG | UEP_R_RES_ACK | UEP_T_RES_NAK;  

				/* SETUPд */
				X0D2SetupLen = pX0D2_SETUP_REQ->wLengthL + ( (UINT16)pX0D2_SETUP_REQ->wLengthH << 8 );
				len = 0;  														/* ĬΪɹϴ0 */
				if( ( pX0D2_SETUP_REQ->bRequestType & USB_REQ_TYP_MASK ) == USB_REQ_TYP_STANDARD ) 
				{  
					/* ׼ */
//					printf("1#: %02x-%02x-%02x-%02x\n",(UINT16)pX0D2_SETUP_REQ->bRequestType,
//								    				   (UINT16)pX0D2_SETUP_REQ->bRequest,
//									    			   (UINT16)pX0D2_SETUP_REQ->wValueL,
//										    		   (UINT16)pX0D2_SETUP_REQ->wValueH);
																			     
					X0D2SetupReqCode = pX0D2_SETUP_REQ->bRequest;
					switch( X0D2SetupReqCode ) 
					{  
						/*  */
						case USB_GET_DESCRIPTOR:
							switch( pX0D2_SETUP_REQ->wValueH ) 
							{
								case USB_DESCR_TYP_DEVICE:  
									/* 豸 */
									X0D2pDescr = &USBD_AllDesc_Buf[ USBD_Desc[ 2 ].Dev_Offset ];
									len = USBD_Desc[ 2 ].Dev_Len;
									break;
									
								case USB_DESCR_TYP_CONFIG:  
									/*  */
									X0D2pDescr = &USBD_AllDesc_Buf[ USBD_Desc[ 2 ].Cfg_Offset ];
									len = USBD_Desc[ 2 ].Cfg_Len;
									break;
									
								case USB_DESCR_TYP_STRING:  
									/* ַ */
									if( pX0D2_SETUP_REQ->wValueL == 0 )
									{
										X0D2pDescr = (PUINT8)( &cHubLangDescr[0] );
										len = sizeof( cHubLangDescr );											
									}
									else if( pX0D2_SETUP_REQ->wValueL == USBD_AllDesc_Buf[ USBD_Desc[ 2 ].Base_Offset + 14 ] )
									{
										X0D2pDescr = &USBD_AllDesc_Buf[ USBD_Desc[ 2 ].Str1_Offset ];
										len = USBD_Desc[ 2 ].Str1_Len;											
									}
									else if( pX0D2_SETUP_REQ->wValueL == USBD_AllDesc_Buf[ USBD_Desc[ 2 ].Base_Offset + 15 ] )
									{
										X0D2pDescr = &USBD_AllDesc_Buf[ USBD_Desc[ 2 ].Str2_Offset ];
										len = USBD_Desc[ 2 ].Str2_Len;											
									}
									else if( pX0D2_SETUP_REQ->wValueL == USBD_AllDesc_Buf[ USBD_Desc[ 2 ].Base_Offset + 16 ] )
									{
										X0D2pDescr = &USBD_AllDesc_Buf[ USBD_Desc[ 2 ].Str3_Offset ];
										len = USBD_Desc[ 2 ].Str3_Len;											
									}
									else if( pX0D2_SETUP_REQ->wValueL == USBD_AllDesc_Buf[ USBD_Desc[ 2 ].Cfg_Offset + 6 ] )
									{
										X0D2pDescr = &USBD_AllDesc_Buf[ USBD_Desc[ 2 ].Str4_Offset ];
										len = USBD_Desc[ 2 ].Str4_Len;											
									}
									else
									{
										/* ֵַ֧ */	
										len = 0xFFFF; 
									}
									break;
									
								case USB_DESCR_TYP_HID:  
									/* HID */
									len = 0xFFFF;
									break;
									
								case USB_DESCR_TYP_REPORT:  
									/* HID */
									switch( pX0D2_SETUP_REQ->wIndexL ) 
									{
										case 0:
											X0D2pDescr = &USBD_AllDesc_Buf[ USBD_Desc[ 2 ].Hid1_Offset ];
											len = USBD_Desc[ 2 ].Hid1_Len;
											break;
											
										case 1:
											X0D2pDescr = &USBD_AllDesc_Buf[ USBD_Desc[ 2 ].Hid2_Offset ];
											len = USBD_Desc[ 2 ].Hid2_Len;	
											break;
											
										case 2:
											X0D2pDescr = &USBD_AllDesc_Buf[ USBD_Desc[ 2 ].Hid3_Offset ];
											len = USBD_Desc[ 2 ].Hid3_Len;
											break;

										case 3:
											X0D2pDescr = &USBD_AllDesc_Buf[ USBD_Desc[ 2 ].Hid4_Offset ];
											len = USBD_Desc[ 2 ].Hid4_Len;
											break;

										case 4:
											X0D2pDescr = &USBD_AllDesc_Buf[ USBD_Desc[ 2 ].Hid5_Offset ];
											len = USBD_Desc[ 2 ].Hid5_Len;
											break;
											
										default:
											/* ֵַ֧ */	
											len = 0xFFFF;  
											break;
									}
									break;
									
								case USB_DESCR_TYP_PHYSIC:  
									/*  */
									len = 0xFFFF; 
									break;
									
								default:
									/* ֵ֧ */	
									len = 0xFFFF;  
									break;
							}
							if( len != 0xFFFF ) 
							{
								if( X0D2SetupLen > len )
								{	 
									X0D2SetupLen = len;  						/* ܳ */
								}
								len = X0D2SetupLen >= EP0_PACKET_SIZE ? EP0_PACKET_SIZE : X0D2SetupLen;  /* δ䳤 */
								X0D2SetupLen -= len;
								memcpy( pX0D2_EP0_BUF, X0D2pDescr, len );   	/* ϴ */
								X0D2pDescr += len;
							}
							break;
							
						case USB_SET_ADDRESS:
							X0D2SetupLen = pX0D2_SETUP_REQ->wValueL;  			/* ݴUSB豸ַ */
							break;
							
						case USB_GET_CONFIGURATION:
							if( X0D2SetupLen )
							{ 
								len = 1;  										/* Ƴ */
							}
							pX0D2_EP0_BUF[ 0 ] = X0D2UsbConfig;
							break;
							
						case USB_SET_CONFIGURATION:
							USBX0_Dev2_Init( 0 );
							X0D2UsbConfig = pX0D2_SETUP_REQ->wValueL;
							break;
							
						case USB_CLEAR_FEATURE:
							if( pX0D2_SETUP_REQ->bRequestType == ( USB_REQ_TYP_STANDARD | USB_REQ_RECIP_ENDP ) ) 
							{  
								/* Ŀ:˵ */
								if( pX0D2_SETUP_REQ->wValueL == 0 ) 
								{  
									/* ENDPOINT_HALT */
									switch( pX0D2_SETUP_REQ->wIndexL )
									{
										case 0x03:  
											/* endpoint 3# ˵´ */
											pX0D2_EP3RES = pX0D2_EP3RES & ~ ( bUEP_X_TOG | MASK_UEP_X_RES ) | UEP_X_RES_ACK;
											break;
											
										case 0x82:  
											/* endpoint 2# ˵ϴ */
											pX0D2_EP2RES = pX0D2_EP2RES & ~ ( bUEP_X_TOG | MASK_UEP_X_RES ) | UEP_X_RES_NAK;
											break;
											
										case 0x81:  
											/* endpoint 1# ˵ϴ	*/
											pX0D2_EP1RES = pX0D2_EP1RES & ~ ( bUEP_X_TOG | MASK_UEP_X_RES ) | UEP_X_RES_NAK;
											break;
											
										default:
											/* ֵ֧Ķ˵ */
											len = 0xFFFF;  
										break;
									}
								}
								else 
								{
									len = 0xFFFF;
								}
							}
							else 
							{  
								/* Ƕ˵ */
								len = 0xFFFF;
							}
							break;
							
						case USB_GET_INTERFACE:
							if( X0D2SetupLen ) 
							{	
								len = 1;  								
							}
							pX0D2_EP0_BUF[ 0 ] = 0x00;
							break;
						case USB_GET_STATUS:  
							if( X0D2SetupLen >= 2 ) 
							{
								len = 2;  										/* Ƴ */
							}
							else
							{	 
								len = X0D2SetupLen;
							}
							rrd0 = pX0D2_SETUP_REQ->bRequestType & USB_REQ_RECIP_MASK;
							if( rrd0 == USB_REQ_RECIP_DEVICE ) 
							{
								pX0D2_EP0_BUF[ 0 ] = 0x01;
							}
							else if( rrd0 == USB_REQ_RECIP_INTERF )
							{	 
								pX0D2_EP0_BUF[ 0 ] = 0x00;
							}
							else if( rrd0 == USB_REQ_RECIP_ENDP ) 
							{
								pX0D2_EP0_BUF[ 0 ] = ( ( pX0D2_SETUP_REQ->wIndexL == 0x81 ? pX0D2_EP1RES
												     : ( pX0D2_SETUP_REQ->wIndexL == 0x82 ? pX0D2_EP2RES
												     : ( pX0D2_SETUP_REQ->wIndexL == 0x03 ? pX0D2_EP3RES : 0x00 ) ) ) & MASK_UEP_X_RES ) == UEP_X_RES_STALL ? 0x01 : 0x00;  // ???
							}
							else 
							{
								pX0D2_EP0_BUF[ 0 ] = 0x00;
							}
							pX0D2_EP0_BUF[ 1 ] = 0x00;
							break;

						case USB_SET_FEATURE: 
							if( ( pX0D2_SETUP_REQ->bRequestType & 0x1F ) == 0x00 )                 
							{                        	
                    			/* 豸 */	
								if( ( ( ( UINT16 )pX0D2_SETUP_REQ->wValueH << 8 ) | pX0D2_SETUP_REQ->wValueL ) == 0x01 )
								{
                        			if( cHubCfgDescr[ 7 ] & 0x20 )
                        			{
                             			/* ûʹܱ־ */
										PCx_SleepStatus[ us & 0x03 ] |= 0x01;
                        			}
                        			else
                        			{
                            			len = 0xFFFF;                       /* ʧ */
                        			}
                      			}
								else
								{
									len = 0xFFFF;                           /* ʧ */
								}
							}
							else if( ( pX0D2_SETUP_REQ->bRequestType & 0x1F ) == 0x02 )             
							{
								/* ö˵ */
								if( ( ( ( UINT16 )pX0D2_SETUP_REQ->wValueH << 8 ) | pX0D2_SETUP_REQ->wValueL ) == 0x00 )
								{
									switch( ( ( UINT16 )pX0D2_SETUP_REQ->wIndexH << 8 ) | pX0D2_SETUP_REQ->wIndexL )
									{
										case 0x81:
											/* ö˵1 IN STALL */
											UEP1_CTRL = UEP1_CTRL & (~bUEP_T_TOG) | UEP_T_RES_STALL;
											break;

										default:
											len = 0xFFFF;                   /* ʧ */
											break;
									}
								}
								else
								{
									len = 0xFFFF;                           /* ʧ */
								}
							}
							else
							{
								len = 0xFFFF;                               /* ʧ */
							}
							
						default:
							/* ʧ */	
							len = 0xFFFF;  
							break;
					}
				}
				else if( ( pX0D2_SETUP_REQ->bRequestType & USB_REQ_TYP_MASK ) == USB_REQ_TYP_CLASS ) 
				{  
					/*  */
					X0D2SetupReqCode = pX0D2_SETUP_REQ->bRequest;
					switch( X0D2SetupReqCode ) 
					{  
						/*  */
						case HID_GET_REPORT:
                            memcpy( pSetupReq, pX0D2_SETUP_REQ , 8 );                                 /* ·GetReport */
                            len = X0D2SetupLen;
                            if( len > 128 )
                            {
                                len = X0D2SetupLen = 128;
                            }
                            USBH_CtrlTransfer( &Sp_SetReport_Pack, &len );
                            X0D2pDescr = Sp_SetReport_Pack;
                            len = X0D2SetupLen >= EP0_PACKET_SIZE ? EP0_PACKET_SIZE : X0D2SetupLen;  /* δ䳤 */
                            X0D2SetupLen -= len;
                            memcpy( pX0D2_EP0_BUF, X0D2pDescr, len );   	/* ϴ */
                            X0D2pDescr += len;
                            break;
							
						case HID_SET_REPORT:
							/* 浱ǰӦĽӿںż */
                            Sp_SetReport_Value = pX0D2_SETUP_REQ->wValueH;
                            Sp_SetReport_Index = 0x10 | pX0D2_SETUP_REQ->wIndexL;
							Sp_SetReport_Len = pX0D2_SETUP_REQ->wLengthL;
							if( Sp_SetReport_Len > 128 )
							{
								Sp_SetReport_Len = 128;
							}
                            Sp_SetReport_SaveLen = Sp_SetReport_Len;
							break;
							
						case HID_GET_IDLE:
							if( X0D2SetupLen ) 
							{	
								len = 1;  
							}	
							pX0D2_EP0_BUF[0] = 0x00;  							/* ʱ */
							break;
							
						case HID_SET_IDLE:
//								= pX0D1_EP0_BUF[3];  							/* ʱ */
							break;
							
						case HID_GET_PROTOCOL:
							if( X0D2SetupLen ) 
							{	
								len = 1;  
							}	
							pX0D2_EP0_BUF[ 0 ] = X0D2_PROTOCOL;  				/* Э־ */
							break;
							
						case HID_SET_PROTOCOL:
							X0D2_PROTOCOL = pX0D2_EP0_BUF[ 2 ];  				/* Э־ */
							break;
							
						default:
							/* ʧ */
							len = 0xFFFF;  
							break;
					}
				}
				else 
				{  
					/* ֱֻ֧׼/ */
					/* ʧ */
					len = 0xFFFF;  
//					printf("ErrEp0ReqType=%02X\n",(UINT16)pX0D1_SETUP_REQ->bRequestType);
				}
				if( len == 0xFFFF ) 
				{  
					/* ʧ */
					X0D2SetupReqCode = 0xFF;
					pX0D2_EP0RES = bUEP_R_TOG | bUEP_T_TOG | UEP_R_RES_STALL | UEP_T_RES_STALL;  /* STALL */
				}
				else if( len <= EP0_PACKET_SIZE ) 
				{  
					/* ϴݻ״̬׶η0Ȱ */
					pX0D2_EP0T_L = len;
					pX0D2_EP0RES = bUEP_R_TOG | bUEP_T_TOG | UEP_R_RES_ACK | UEP_T_RES_ACK;  /* ĬݰDATA1 */
				}
				else 
				{  /* ´ݻ */
					pX0D2_EP0T_L = 0;  /* Ȼδ״̬׶ΣǰԤϴ0ݰԷǰ״̬׶ */
					pX0D2_EP0RES = bUEP_R_TOG | bUEP_T_TOG | UEP_R_RES_ACK | UEP_T_RES_ACK;  /*/ ĬݰDATA1 */
				}
			}
			else
			{
				switch( pX0D2_STATUS & ( bUXS_SETUP_ACT | MASK_UXS_TOKEN | MASK_UXS_ENDP ) ) 
				{  
					/* ƺͶ˵ */	
					case UXS_TOKEN_IN | 1:  
					case bUXS_SETUP_ACT | UXS_TOKEN_IN | 1:
						/* ˵1# ˵ϴ */
						pX0D2_EP1RES ^= bUEP_X_TOG;
						pX0D2_EP1RES = pX0D2_EP1RES & ~MASK_UEP_X_RES | UEP_X_RES_NAK; 	/* ͣϴ */

						/* HIDϴ־ */
						PCx_HidUpStatus[ us & 0x03 ][ 2 ] = 0x00;
						break;
	
					case UXS_TOKEN_IN | 2:  
					case bUXS_SETUP_ACT | UXS_TOKEN_IN | 2:
						/* ˵2# ˵ϴ */
						pX0D2_EP2RES ^= bUEP_X_TOG;	
						pX0D2_EP2RES = pX0D2_EP2RES & ~MASK_UEP_X_RES | UEP_X_RES_NAK; 	/* ͣϴ */

						/* HIDϴ־ */
						PCx_HidUpStatus[ us & 0x03 ][ 2 ] = 0x00;
						break;
	
					case UXS_TOKEN_IN | 3:  
					case bUXS_SETUP_ACT | UXS_TOKEN_IN | 3:
						/* ˵3# ˵ϴ */
						pX0D2_EP3RES ^= bUEP_X_TOG;
						pX0D2_EP3RES = pX0D2_EP3RES & ~MASK_UEP_X_RES | UEP_X_RES_NAK;  /* ͣϴ */

						/* HIDϴ־ */
						PCx_HidUpStatus[ us & 0x03 ][ 2 ] = 0x00;
						break;
	
					case UXS_TOKEN_IN | 4:  
					case bUXS_SETUP_ACT | UXS_TOKEN_IN | 4:
						/* ˵4# ˵ϴ */
						pX0D2_EP4RES ^= bUEP_X_TOG;
						pX0D2_EP4RES = pX0D2_EP4RES & ~MASK_UEP_X_RES | UEP_X_RES_NAK;  /* ͣϴ */

						/* HIDϴ־ */
						PCx_HidUpStatus[ us & 0x03 ][ 2 ] = 0x00;
						break;
	
					case UXS_TOKEN_IN | 5:  
					case bUXS_SETUP_ACT | UXS_TOKEN_IN | 5:
						/* ˵5# ˵ϴ */
						pX0D2_EP5RES ^= bUEP_X_TOG;
						pX0D2_EP5RES = pX0D2_EP5RES & ~MASK_UEP_X_RES | UEP_X_RES_NAK;  /* ͣϴ */

						/* HIDϴ־ */
						PCx_HidUpStatus[ us & 0x03 ][ 2 ] = 0x00;
						break;
	
					case UXS_TOKEN_IN | 6:  
					case bUXS_SETUP_ACT | UXS_TOKEN_IN | 6:
						/* ˵6# ˵ϴ */
						pX0D2_EP6RES ^= bUEP_X_TOG;
						pX0D2_EP6RES = pX0D2_EP6RES & ~MASK_UEP_X_RES | UEP_X_RES_NAK;  /* ͣϴ */

						/* HIDϴ־ */
						PCx_HidUpStatus[ us & 0x03 ][ 2 ] = 0x00;
						break;				
						
					case UXS_TOKEN_IN | 0:  
					case bUXS_SETUP_ACT | UXS_TOKEN_IN | 0:
						/* ˵0# IN */
						switch( X0D2SetupReqCode ) 
						{
							case HID_GET_REPORT:
                            case USB_GET_DESCRIPTOR:
								len = X0D2SetupLen >= EP0_PACKET_SIZE ? EP0_PACKET_SIZE : X0D2SetupLen;  // δ䳤 */
								X0D2SetupLen -= len;
								memcpy( pX0D2_EP0_BUF, X0D2pDescr, len );  		/* ϴ */
								X0D2pDescr += len;
								pX0D2_EP0T_L = len;
								pX0D2_EP0RES ^= bUEP_T_TOG;  					/* ת */
								break;
								
							case USB_SET_ADDRESS:
								pX0D2_ADDR = X0D2SetupLen;
								pX0D2_EP0RES = UEP_R_RES_ACK | UEP_T_RES_NAK;
								break;
								
							default:
								pX0D2_EP0T_L = 0;  								/* ״̬׶жϻǿϴ0ݰƴ */
								pX0D2_EP0RES = UEP_R_RES_ACK | UEP_T_RES_NAK;
								break;
								
						}
						break;
						
					case UXS_TOKEN_OUT | 0:  
					case bUXS_SETUP_ACT | UXS_TOKEN_OUT | 0:
						/* endpoint 0# OUT */
						switch( X0D2SetupReqCode ) 
						{
						   case 0x09:
								/* ̵ */

								/* жǰӿǼΪ̵ƿ,Ϊ¼,Ҫ͸ */
								if( ( HostCtl[ 2 ].Interface[ ( Sp_SetReport_Index & 0x0F ) ].Type == DEC_KEY ) &&
								    ( Sp_SetReport_Len <= 2 ) )
								{
									/* 浱ǰָʾֵ */
									if( HostCtl[ 2 ].Interface[ ( Sp_SetReport_Index & 0x0F ) ].HidReportID &&
										( HostCtl[ 2 ].Interface[ ( Sp_SetReport_Index & 0x0F ) ].HidReportID == pX0D2_EP0_BUF[ 0 ] ) )
									{
										PCx_KBSetReport[ us & 0x03 ] = pX0D2_EP0_BUF[ 1 ];
									}
									else
									{
										PCx_KBSetReport[ us & 0x03 ] = pX0D2_EP0_BUF[ 0 ];
									}
									Sp_SetReport_Len = 0x00;
								}
                                else
								{
									if( Sp_SetReport_SaveLen > 64 )
                                    {
                                        memcpy( Sp_SetReport_Pack, pX0D2_EP0_BUF, 64 );
                                        Sp_SetReport_SaveLen -= 64;
                                    }
                                    else
                                    {
                                        memcpy( &Sp_SetReport_Pack[ Sp_SetReport_Len - Sp_SetReport_SaveLen ], pX0D2_EP0_BUF, Sp_SetReport_SaveLen );
                                        Sp_SetReport_Len |= 0x80;
                                    }			
								}
	 							pX0D2_EP0T_L = 0;
								pX0D2_EP0RES = bUEP_R_TOG | bUEP_T_TOG | UEP_R_RES_ACK | UEP_T_RES_ACK;  /* ĬݰDATA1 */
								break;
	
							case USB_GET_DESCRIPTOR:
							default:
								if ( pX0D2_STATUS & bUXS_TOG_OK ) 
								{  
									/* ͬݰ */
	//								if ( pX0D1_RX_LEN ) control_status_error;
	//								else control_ok;  // յ0Ȱʾƶ/ϴOK */
								}
	//							else control_status_error;
								pX0D2_EP0RES = UEP_R_RES_ACK | UEP_T_RES_NAK;   /* ׼һƴ */
								break;
						}
						break;
					default:
	//					printf("ErrEndpInt\n");
						break;
				}
			}
			UIF_USBX_IF = 0;  													/* жϱ־ */
			break;
			
//		case ( bUSBX_DEV_ID0 | bUSBX_DEV_ID1 ):  // hub
		default:
			/**************************************************************************/
			/* HUB豸 */
			if( pUSBX0_IF & bUX_IF_HB_TRANS ) 
			{  
				/* STEUP,ֹһSTALL,һ */
				if( ( pX0HB_STATUS & ( bUXS_SETUP_ACT | MASK_UXS_TOKEN ) ) == ( bUXS_SETUP_ACT | MASK_UXS_TOKEN ) )
				{
					/* endpoint 0# SETUP */

					/* ӴξǰһSTALLһ޷ */
					pX0HB_EP0RES = bUEP_R_TOG | bUEP_T_TOG | UEP_R_RES_ACK | UEP_T_RES_NAK;  

					X0HBSetupLen = pX0HB_SETUP_REQ->wLengthL;
					if( pX0HB_SETUP_REQ->wLengthH || X0HBSetupLen > MAX_DESCR_SIZE ) 
					{
						X0HBSetupLen = MAX_DESCR_SIZE;  						/* ܳ */
					}
					len = 0;  													/* ĬΪɹϴ0 */
					if( ( pX0HB_SETUP_REQ->bRequestType & USB_REQ_TYP_MASK ) == USB_REQ_TYP_STANDARD ) 
					{  
						/* ׼ */
//						printf("HU#: %02x-%02x-%02x-%02x\n",(UINT16)pX0HB_SETUP_REQ->bRequestType,
//									    				   (UINT16)pX0HB_SETUP_REQ->bRequest,
//										    			   (UINT16)pX0HB_SETUP_REQ->wValueL,
//											    		   (UINT16)pX0HB_SETUP_REQ->wValueH);
						X0HBSetupReqCode = pX0HB_SETUP_REQ->bRequest;
						switch( X0HBSetupReqCode ) 
						{  
							/*  */
							case USB_GET_DESCRIPTOR:
								switch( pX0HB_SETUP_REQ->wValueH ) 
								{
									case USB_DESCR_TYP_DEVICE:  				/* 豸 */
										if( PCx_NumMax == DEX_USBX_NUM_MAX_2 )
										{
											cHubDevDescr[ 10 ] = 0x72;
										}
										X0HBpDescr = (PUINT8)( &cHubDevDescr[ 0 ] );
										len = sizeof( cHubDevDescr );
										break;

									case USB_DESCR_TYP_CONFIG:  				/*  */
										X0HBpDescr = (PUINT8)( &cHubCfgDescr[ 0 ] );
										len = sizeof( cHubCfgDescr );
										break;

									case USB_DESCR_TYP_STRING:  				/* ַ */
										switch( pX0HB_SETUP_REQ->wValueL ) 
										{
											case STR_DES_HUB_MANU:
												X0HBpDescr = (PUINT8)( &cHubManuInfo[ 0 ] );
												len = sizeof( cHubManuInfo );
												break;

											case STR_DES_HUB_PROD:
												X0HBpDescr = (PUINT8)( &cHubProdInfo[ 0 ] );
												len = sizeof( cHubProdInfo );
												break;

											case 0:
												X0HBpDescr = (PUINT8)( &cHubLangDescr[ 0 ] );
												len = sizeof( cHubLangDescr );
												break;

											default:
												len = 0xFFFF;  					/* ֵַ֧ */
												break;
										}
										break;

									default:
										len = 0xFFFF;  							/* ֵ֧ */
										break;
								}
								if( len != 0xFFFF ) 
								{
									if( X0HBSetupLen > len ) 
									{
										X0HBSetupLen = len;  					/* ܳ */
									}
									len = X0HBSetupLen >= EP0_PACKET_SIZE ? EP0_PACKET_SIZE : X0HBSetupLen;  /* δ䳤 */
									X0HBSetupLen -= len;
									memcpy( pX0HB_EP0_BUF, X0HBpDescr, len ); 	/* ϴ */
									X0HBpDescr += len;
								}
								break;

							case USB_SET_ADDRESS:
								X0HBSetupLen = pX0HB_SETUP_REQ->wValueL;  		/* ݴUSB豸ַ */
								break;

							case USB_GET_CONFIGURATION:
								if ( X0HBSetupLen ) len = 1;  
								{
									/* Ƴ */
								}
								pX0HB_EP0_BUF[ 0 ] = X0HBUsbConfig;
								break;

							case USB_SET_CONFIGURATION:
								USBX0_Hub_Init( FALSE );
								X0HBUsbConfig = pX0HB_SETUP_REQ->wValueL;
								if( X0HBUsbConfig ) 
								{  
									/*  */
	//								USBX_ThisHub_EP1IntUp( (X0DevBitFlag[0]?0x02:0)|(X0DevBitFlag[1]?0x04:0)|(X0DevBitFlag[2]?0x08:0)|(X0DevBitFlag[3]?0x10:0) );  // ΪǰUSBXϴHUBж֪ͨ */
								}
								
//								/* õǰUSBӱ־ */
//								PCx_Connect_CurStatus |= 1 << ( us & 0x03 );
								PCx_HubStatus[ us & 0x03 ] = 0x01;
								PCx_HubChk_TimeCount[ us & 0x03 ] = 0x00;
								break;

							case USB_CLEAR_FEATURE:
								if( pX0HB_SETUP_REQ->bRequestType == ( USB_REQ_TYP_STANDARD | USB_REQ_RECIP_ENDP ) ) 
								{  
									/* Ŀ:˵ */
									if( pX0HB_SETUP_REQ->wValueL == 0 ) 
									{  
										/* ENDPOINT_HALT */
										switch( pX0HB_SETUP_REQ->wIndexL ) 
										{
											case 0x81:  
												/* endpoint 1# ˵ϴ */
												pX0HB_EP1RES = pX0HB_EP1RES & ~ ( bUEP_X_TOG | MASK_UEP_X_RES ) | UEP_X_RES_NAK;
												break;

											default:
												len = 0xFFFF;  				/* ֵ֧Ķ˵ */
												break;
										}
									}
									else 
									{
										len = 0xFFFF;
									}
								}
								else if( ( pX0HB_SETUP_REQ->bRequestType & USB_REQ_RECIP_MASK ) == USB_REQ_RECIP_DEVICE )
								{
									if( pX0HB_SETUP_REQ->wValueL ==	1 )
									{
										PCx_SleepStatus[ us & 0x03 ] &= ~0x01;
									}
								}
								else 
								{  
									/* Ƕ˵ */
									len = 0xFFFF;
								}
								break;

							case USB_GET_INTERFACE:
								if( X0HBSetupLen ) 
								{
									len = 1;  									/* Ƴ */
								}
								pX0HB_EP0_BUF[ 0 ] = 0x00;
								break;

							case USB_GET_STATUS:  
								if( X0HBSetupLen >= 2 ) 
								{
									len = 2;  									/* Ƴ */
								}
								else 
								{
									len = X0HBSetupLen;
								}
								rrhb = pX0HB_SETUP_REQ->bRequestType & USB_REQ_RECIP_MASK;
								if( rrhb == USB_REQ_RECIP_DEVICE ) 
								{
									pX0HB_EP0_BUF[0] = 0x01;
								}
								else if( rrhb == USB_REQ_RECIP_INTERF )
								{ 
									pX0HB_EP0_BUF[0] = 0x00;
								}
								else if( rrhb == USB_REQ_RECIP_ENDP ) 
								{
									pX0HB_EP0_BUF[ 0 ] = ( ( pX0HB_SETUP_REQ->wIndexL == 0x81 ? pX0HB_EP1RES : 0x00 ) & MASK_UEP_X_RES ) == UEP_X_RES_STALL ? 0x01 : 0x00;  // ???
								}
								else 
								{
									pX0HB_EP0_BUF[ 0 ] = 0x00;
								}
								pX0HB_EP0_BUF[ 1 ] = 0x00;
								break;

							case USB_SET_FEATURE:  
								if( ( pX0HB_SETUP_REQ->bRequestType & 0x1F ) == 0x00 )                 
								{                       	
	                    			/* 豸 */	
									if( ( ( ( UINT16 )pX0HB_SETUP_REQ->wValueH << 8 ) | pX0HB_SETUP_REQ->wValueL ) == 0x01 )
									{
	                        			if( cHubCfgDescr[ 7 ] & 0x20 )
	                        			{
	                             			/* ûʹܱ־ */
											PCx_SleepStatus[ us & 0x03 ] |= 0x01;
//											printf( "@P:%x\n",(UINT16)(us & 0x03) );
	                        			}
	                        			else
	                        			{
	                            			len = 0xFFFF;                       /* ʧ */
	                        			}
	                      			}
									else
									{
										len = 0xFFFF;                           /* ʧ */
									}
								}
								break;

							default:
								len = 0xFFFF;  // ʧ */
//									printf("ErrEp0ReqCode=%02X\n",(UINT16)X0HBSetupReqCode);
								break;
						}
					}
					else if( ( pX0HB_SETUP_REQ->bRequestType & USB_REQ_TYP_MASK ) == USB_REQ_TYP_CLASS ) 
					{  
						/*  */
//						printf("HUB#: %02x-%02x-%02x-%02x\n",(UINT16)pX0HB_SETUP_REQ->bRequestType,
//									    				    (UINT16)pX0HB_SETUP_REQ->bRequest,
//										    			    (UINT16)pX0HB_SETUP_REQ->wValueL,
//											    	   	    (UINT16)pX0HB_SETUP_REQ->wValueH);

						X0HBSetupReqCode = pX0HB_SETUP_REQ->bRequest;
						switch( X0HBSetupReqCode ) 
						{  
							/*  */
							case HUB_GET_DESCRIPTOR:  
								/* HUB */
								if( X0HBSetupLen > sizeof( cHubClsDescr ) ) 
								{
									X0HBSetupLen = sizeof( cHubClsDescr );  
								}
								len = X0HBSetupLen >= EP0_PACKET_SIZE ? EP0_PACKET_SIZE : X0HBSetupLen;  /* δ䳤 */
								X0HBSetupLen -= len;
								X0HBpDescr = (PUINT8)( &cHubClsDescr[ 0 ] );
								memcpy( pX0HB_EP0_BUF, X0HBpDescr, len );  		/* ϴ */
								X0HBpDescr += len;
								break;

							case USB_SET_FEATURE:
								if( pX0HB_SETUP_REQ->bRequestType == ( USB_REQ_TYP_CLASS | USB_REQ_RECIP_OTHER ) ) 
								{  
									/* Ŀ */
									PortIndex = pX0HB_SETUP_REQ->wIndexL - 1;	/* ˿ */
									if( PortIndex <= 3 ) 
									{
										switch( pX0HB_SETUP_REQ->wValueL ) 
										{  
											/* ѡ */
											case HUB_PORT_RESET:  
												/* ˿ڸλ */
												if( PortIndex != 3 ) 
												{
													if( PortIndex == 0 ) 
													{
														USBX0_Dev0_Init( 2 );
													}
													else if( PortIndex == 1 ) 
													{
														USBX0_Dev1_Init( 2 );
													}
													else 
													{
														USBX0_Dev2_Init( 2 );
													}
													X0DevBitFlag[ PortIndex ] = BIT_PORT_CONNECT | BIT_PORT_C_REST;  /* ֶ˿״̬,λ */
													USBX_ThisHub_EP1IntUp( 0x01 << ( PortIndex + 1 ) );  /* ΪǰUSBXϴHUBж֪ͨ */
												}
												else 
												{
													X0DevBitFlag[ 3 ] = 0x00; 	/* ˿ڿ */	
													
													/* ж϶˿ϵ豸ǷȻ */
													for( i = 0; i < TOTAL_ROOT_HUB; i++ )
													{
														if( RootHubDev[ i ].DeviceIndex == 3 )
														{
															break;
														}
													}
											
													if( ( USBX_SEL & MASK_UX_PC_SEL ) == PCx_PassUSB_ActionNum && ( PCx_Dev3_Status & BIT_DEV3_IS_PASS ) ) 
													{  
														/* ǰPCҪֱ */
														USB_CTRL &= ~bUC_THROUGH;/* USBֱֹͨ */
														USBH_ResetRootHubPort( PCx_Dev3_Status & BIT_DEV3_ROOT_IDX, 1 );  /* ʼλ */
														EA = 0;
														USBH_ResetTimer = TASK_TIMER_RESET;  /* ʱ */
														EA = 1;
//														printf("PC_RST:%x\n",(UINT16)USBH_ResetTimer);
														PCx_Dev3_Status |= BIT_DEV3_PC_RESET;
														PCx_Dev3_ResetFlag = 1;
													}
													else 
													{
//														len = 0xFFFF;  			/* ʧ */
													}
												}
												break;

											case HUB_PORT_POWER:  				/* ˿ϵ */
												break;

											case HUB_PORT_SUSPEND:  			/* ˿ڹ */
												break;

											default:
												len = 0xFFFF;  					/* ʧ */
												break;
										}
									}
									else 
									{
										len = 0xFFFF;  							/* ʧ */
									}
								}
								else 
								{
									len = 0xFFFF;  								/* ʧ */
								}
								break;

							case HUB_CLEAR_FEATURE:
								if( pX0HB_SETUP_REQ->bRequestType == ( USB_REQ_TYP_CLASS | USB_REQ_RECIP_OTHER ) ) 
								{  
									/* Ŀ */
									PortIndex = pX0HB_SETUP_REQ->wIndexL - 1;  	/* ˿ */
									if( PortIndex <= 3 ) 
									{
										switch( pX0HB_SETUP_REQ->wValueL ) 
										{  
											/* ѡ */
											case HUB_PORT_ENABLE:  
												/* ˿ڽֹ */
												if( PortIndex == 0 )
												{ 
													pX0D0_EP_MOD &= ~bUX_DEV_EN;  
												}
												else if( PortIndex == 1 ) 
												{
													pX0D1_EP_MOD &= ~bUX_DEV_EN;  
												}
												else if( PortIndex == 2 ) 
												{
													pX0D2_EP_MOD &= ~bUX_DEV_EN;  
												}
												else 
												{
													USB_CTRL &= ~bUC_THROUGH;  
												}
												break;

											case HUB_PORT_POWER:  				/* ˿µ */
												break;

											case HUB_PORT_SUSPEND:  			/* ˿ڻ */
												break;

											case HUB_C_PORT_CONNECTION:  
												/* ˿Ӹı */
												X0DevBitFlag[ PortIndex ] &= ~BIT_PORT_C_CONN;
												break;

											case HUB_C_PORT_RESET:  
												/* ˿ڸλ */
												X0DevBitFlag[PortIndex] &= ~BIT_PORT_C_REST;  

												/* 嵱ǰ˿ж֪ͨ¼־ */
												PCx_TaskStatus[ us & 0x03 ] &= ~( 1 << PortIndex );

												/* ͣϴ */
												pX0HB_EP1RES = pX0HB_EP1RES & ~MASK_UEP_X_RES | UEP_X_RES_NAK;  
												break;

											default:
//													len = 0xFFFF;  				/* ʧ */
												break;
										}
									}
									else 
									{
										len = 0xFFFF;  							/* ʧ */
									}
								}
//									else if ( pX0HB_SETUP_REQ->bRequestType == ( USB_REQ_TYP_CLASS | USB_REQ_RECIP_DEVICE ) ) {
//										len = 0x00;
//									}
								else 
								{
//										len = 0xFFFF;  							/* ʧ
								}
								break;

							case HUB_GET_STATUS:
								if( X0HBSetupLen >= 4 ) 
								{
									len = 4;  									/* Ƴ */
								}
								else 
								{
									len = X0HBSetupLen;
								}
								PortIndex = pX0HB_SETUP_REQ->wIndexL - 1;   	/* ˿ */

								rrhbc = pX0HB_SETUP_REQ->bRequestType & USB_REQ_RECIP_MASK;
								pX0HB_EP0_BUF[ 0 ] = 0x00;
								pX0HB_EP0_BUF[ 1 ] = 0x00;
								pX0HB_EP0_BUF[ 2 ] = 0x00;
								pX0HB_EP0_BUF[ 3 ] = 0x00;
								if( rrhbc == USB_REQ_RECIP_OTHER ) 
								{  
									/* Ŀ */
									if( PortIndex <= 3 ) 
									{
										pX0HB_EP0_BUF[ 1 ] |= 0x01 << ( HUB_PORT_POWER - 8 );  /* Ѿϵ */

										if( X0DevBitFlag[ PortIndex ] & BIT_PORT_C_CONN ) 
										{
											pX0HB_EP0_BUF[ 2 ] |= 0x01 << HUB_PORT_CONNECTION;  /* ״̬ı */
										}
										if( X0DevBitFlag[ PortIndex ] & BIT_PORT_CONNECT ) 
										{  
											/* Ѿ */
											if( PortIndex != 3 ) 
											{
												if( ( PortIndex == 0 ? pX0D0_EP_MOD : ( PortIndex == 1 ? pX0D1_EP_MOD : pX0D2_EP_MOD ) ) & bUX_DEV_EN )
												{ 
													pX0HB_EP0_BUF[ 0 ] |= 0x01 << HUB_PORT_ENABLE;  /* ˿ʹ */
												}
												pX0HB_EP0_BUF[ 0 ] |= 0x01 << HUB_PORT_CONNECTION;  /* 豸 */
												if( X0DevBitFlag[ PortIndex ] & BIT_PORT_C_REST ) 
												{
													pX0HB_EP0_BUF[ 2 ] |= 0x01 << HUB_PORT_RESET;   /* λ */
												}
											}
											else 
											{  
												/* ֱͨ豸 */
												if( ( UH_THROUGH & MASK_UH_THR_UX ) == ( USBX_SEL & MASK_UX_PC_SEL ) ) 
												{  
													/* ǰֱͨ豸 */
//													pX0HB_EP0_BUF[ 0 ] |= 0x01 << HUB_PORT_ENABLE;  /* ˿ʹ */
													if( USB_CTRL & bUC_THROUGH ) 
													{
														pX0HB_EP0_BUF[ 0 ] |= 0x01 << HUB_PORT_ENABLE;  /* ˿ʹ */
													}														
													else if( USBH_ResetTimer ) 
													{
														pX0HB_EP0_BUF[ 0 ] |= 0x01 << HUB_PORT_RESET;  /* 豸߸λ */
													}
													pX0HB_EP0_BUF[ 0 ] |= 0x01 << HUB_PORT_CONNECTION;  /* 豸 */
													if( X0DevBitFlag[ PortIndex ] & BIT_PORT_C_REST ) 
													{
														pX0HB_EP0_BUF[ 2 ] |= 0x01 << HUB_PORT_RESET;   /* λ */
													}
												}
												else 
												{
													X0DevBitFlag[ 3 ] = 0x00;  /* ǰѱл */
												}
											}
										}

		 								PCx_HubStatus[ us & 0x03 ] = 0x02;
										PCx_HubChk_TimeCount[ us & 0x03 ] = 900;
									}
								}
//								else if ( rrhbc == USB_REQ_RECIP_DEVICE ) {
//								}
								else 
								{
//									len = 0xFFFF;  /* ʧ */

									/* յA0 00 00 00 00 00 04 00HUBö */

									/* õǰUSBӱ־ */
									PCx_Connect_CurStatus |= 1 << ( us & 0x03 );
									PCx_HubStatus[ us & 0x03 ] = 0x00;
								}
								break;
									
							default:
								len = 0xFFFF;  /* ʧ */
//								printf("ErrEp0ReqCode=%02X\n",(UINT16)X0HBSetupReqCode);
								break;
						}
					}
					else 
					{  
						/* ֱֻ֧׼/ */
						len = 0xFFFF;  											/* ʧ */
					}
					if( len == 0xFFFF ) 
					{  
						/* ʧ */
						X0HBSetupReqCode = 0xFF;
						pX0HB_EP0RES = bUEP_R_TOG | bUEP_T_TOG | UEP_R_RES_STALL | UEP_T_RES_STALL;  /* STALL */
					}
					else if( len <= EP0_PACKET_SIZE ) 
					{  
						/* ϴݻ״̬׶η0Ȱ */
						pX0HB_EP0T_L = len;
						pX0HB_EP0RES = bUEP_R_TOG | bUEP_T_TOG | UEP_R_RES_ACK | UEP_T_RES_ACK;  /* ĬݰDATA1 */
					}
					else 
					{  
						/* ´ݻ */
						pX0HB_EP0T_L = 0;  		/* Ȼδ״̬׶ΣǰԤϴ0ݰԷǰ״̬׶ */
						pX0HB_EP0RES = bUEP_R_TOG | bUEP_T_TOG | UEP_R_RES_ACK | UEP_T_RES_ACK;  /* ĬݰDATA1 */
					}
				}
				else
				{
					switch( pX0HB_STATUS & ( bUXS_SETUP_ACT | MASK_UXS_TOKEN | MASK_UXS_ENDP ) ) 
					{  
						/* ƺͶ˵ */
						case UXS_TOKEN_IN | 1:  
						case bUXS_SETUP_ACT | UXS_TOKEN_IN | 1:
							/* endpoint 1# ж϶˵ϴ */
							pX0HB_EP1RES ^= bUEP_X_TOG;  									/* Զת */
							pX0HB_EP1RES = pX0HB_EP1RES & ~ MASK_UEP_X_RES | UEP_X_RES_NAK; /* ͣϴ */
							pX0HB_EP1_BUF[ 0 ] = 0x00;
							break;
	
						case UXS_TOKEN_IN | 0:  
						case bUXS_SETUP_ACT | UXS_TOKEN_IN | 0:
							/* endpoint 0# IN */
							switch( X0HBSetupReqCode ) 
							{
								case USB_GET_DESCRIPTOR:
									len = X0HBSetupLen >= EP0_PACKET_SIZE ? EP0_PACKET_SIZE : X0HBSetupLen;  /* δ䳤 */
									X0HBSetupLen -= len;
									memcpy( pX0HB_EP0_BUF, X0HBpDescr, len );   /* ϴ */
									X0HBpDescr += len;
									pX0HB_EP0T_L = len;
									pX0HB_EP0RES ^= bUEP_T_TOG;  				/* ת */
									break;
									
								case USB_SET_ADDRESS:
									pX0HB_ADDR = X0HBSetupLen;
									pX0HB_EP0RES = UEP_R_RES_ACK | UEP_T_RES_NAK;
									break;
									
								default:
									pX0HB_EP0T_L = 0;  							/* ״̬׶жϻǿϴ0ݰƴ */
									pX0HB_EP0RES = UEP_R_RES_ACK | UEP_T_RES_NAK;
									break;
							}
							break;
							
						case UXS_TOKEN_OUT | 0:  
						case bUXS_SETUP_ACT | UXS_TOKEN_OUT | 0:
							/* endpoint 0# OUT */
							switch( X0HBSetupReqCode ) 
							{
								case USB_GET_DESCRIPTOR:
								default:
									if( pX0HB_STATUS & bUXS_TOG_OK ) 
									{  /* ͬݰ */
	//									if ( pX0HB_RX_LEN ) control_status_error;
	//									else control_ok;  // յ0Ȱʾƶ/ϴOK */
									}
	//								else control_status_error;
									pX0HB_EP0RES = UEP_R_RES_ACK | UEP_T_RES_NAK;/* ׼һƴ */
									break;
							}
							break;
							
						default:
	//						printf("ErrEndpInt\n");
							break;
							
					}
				}
				UIF_USBX_IF = 0;  												/* жϱ־ */
			}
			if( pUSBX0_IF & bUX_IF_BUS_RST ) 
			{  
				/* USBX߸λ */
//				printf("@R\n");				
//				pX0HB_ADDR = pX0D2_ADDR = pX0D1_ADDR = pX0D0_ADDR = 0x00;
//				pX0HB_EP0RES = pX0D2_EP0RES = pX0D1_EP0RES = pX0D0_EP0RES = UEP_R_RES_ACK | UEP_T_RES_NAK;
//				pUSBX0_IF = 0xFF;  // clear all interrupt flag
				USBX0_Hub_Init( TRUE );

				/* õǰUSBѶϿ־ */
				PCx_Connect_CurStatus &= ~( 1 << ( us & 0x03 ) );

				/* ز */
				PCx_HubStatus[ us & 0x03 ] = 0x00;						
				PCx_HubChk_TimeCount[ us & 0x03 ] = 0x00;
				PCx_SleepStatus[ us & 0x03 ] = 0x00;
				for( i = 0; i < 3; i++ )
				{
					PCx_HidUpStatus[ us & 0x03 ][ i ] = 0x00;
					PCx_HidUp_TimeCount[ us & 0x03 ][ i ] = 0x00;
				} 		
			}
			if( pUSBX0_IF & bUX_IF_SUSPEND ) 
			{  
				/* USBX߹/ */				
//				printf( "@S\n" );

				/* ˯߻ѱ־ */
				if( PCx_SleepStatus[ us & 0x03 ] == 0x01 )
				{
//					printf( "@L:%x\n",(UINT16)(us & 0x03) );
					PCx_SleepStatus[ us & 0x03 ] |= 0x02;
				}

				/* ж */
				pUSBX0_IF = bUX_IF_SUSPEND;  
				USBX_SEL = 0x00;  												/* Զƫ */
				if( ( ( pUSBX0_IF & pUSBX1_IF & pUSBX2_IF & pUSBX3_IF ) & bUX_SUSPEND ) && ( USBH_ReadyTimer == 0 ) && ( USBH_ResetTimer == 0 ) ) 
				{  
					/* all suspend */
//					printf( "@S2" );  											/* ˯״̬ */

					while ( XBUS_AUX & bUART0_TX );  							/* ȴ */
					while ( ( USB_MIS_ST & ( bUMS_SOF_PRES | bUMS_SOF_ACT | bUMS_SIE_FREE ) ) != bUMS_SIE_FREE );
#if 0
					SAFE_MOD = 0x55;
					SAFE_MOD = 0xAA;
					WAKE_CTRL = bWAK_BY_USB | bWAK_BY_USBX | bWAK_RXD0_LO;  	/* USBUSBXRXD0źʱɱ */
					PCON |= PD;  												/* ˯ */
					SAFE_MOD = 0x55;
					SAFE_MOD = 0xAA;
					WAKE_CTRL = 0x00;
#endif
//					printf( "@W" );  											/* ˯״̬ */
				}
			}
			break;
	}
	if( USBX_INT & ( bUSBX0_INT_ACT | bUSBX1_INT_ACT | bUSBX2_INT_ACT | bUSBX3_INT_ACT ) )
	{ 
		goto USBX_DevIntNext;
	}
//	USBX_SEL = 0x00;
	USBX_SEL = save;
}

#pragma	modp2

/*******************************************************************************
* Function Name  : USBX_Endpx_UpData
* Description    : USBX豸ָ豸ŵָ˵ϴ
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void USBX_Endpx_UpData( UINT8 pcx, UINT8 devx, UINT8 endpx, UINT8 *pbuf, UINT8 len ) 
{
	EA = 0;  					
	USBX_SEL = bUSBX_XSFR_OFS | bUSBX_XRAM_OFS | pcx;	
	switch( endpx )
	{
		case 1:
			/* ˵1ϴ */
			memcpy( pUSBXi_BUF_DEVj( pcx, devx ) + UX_EP1_ADDR, pbuf, len );  
			pXiDj_EP1T_L( pcx, devx ) = len;
			pXiDj_EP1RES( pcx, devx ) = pXiDj_EP1RES( pcx, devx ) & ~MASK_UEP_X_RES | UEP_X_RES_ACK;  /* ϴ,Զת */
			break;
			
		case 2:
			/* ˵2ϴ */
			memcpy( pUSBXi_BUF_DEVj( pcx, devx ) + UX_EP2_ADDR, pbuf, len );  
			pXiDj_EP2T_L( pcx, devx ) = len;
			pXiDj_EP2RES( pcx, devx ) = pXiDj_EP2RES( pcx, devx ) & ~MASK_UEP_X_RES | UEP_X_RES_ACK;  /* ϴ,Զת */
			break;

		case 3:
			/* ˵3ϴ */
			memcpy( pUSBXi_BUF_DEVj( pcx, devx ) + UX_EP3_ADDR, pbuf, len );  
			pXiDj_EP3T_L( pcx, devx ) = len;
			pXiDj_EP3RES( pcx, devx ) = pXiDj_EP3RES( pcx, devx ) & ~MASK_UEP_X_RES | UEP_X_RES_ACK;  /* ϴ,Զת */
			break;	
			
//		case 4:
//			/* ˵4ϴ */
//			memcpy( pUSBXi_BUF_DEVj( pcx, devx ) + UX_EP4_ADDR, pbuf, len );  
//			pXiDj_EP4T_L( pcx, devx ) = len;
//			pXiDj_EP4RES( pcx, devx ) = pXiDj_EP4RES( pcx, devx ) & ~MASK_UEP_X_RES | UEP_X_RES_ACK;  /* ϴ,Զת */
//			break;				
//			
		case 5:
			/* ˵5ϴ */
			memcpy( pUSBXi_BUF_DEVj( pcx, devx ) + UX_EP5_ADDR, pbuf, len );  
			pXiDj_EP5T_L( pcx, devx ) = len;
			pXiDj_EP5RES( pcx, devx ) = pXiDj_EP5RES( pcx, devx ) & ~MASK_UEP_X_RES | UEP_X_RES_ACK;  /* ϴ,Զת */
			break;									

		case 6:
			/* ˵6ϴ */
			memcpy( pUSBXi_BUF_DEVj( pcx, devx ) + UX_EP6_ADDR, pbuf, len );  
			pXiDj_EP6T_L( pcx, devx ) = len;
			pXiDj_EP6RES( pcx, devx ) = pXiDj_EP6RES( pcx, devx ) & ~MASK_UEP_X_RES | UEP_X_RES_ACK;  /* ϴ,Զת */
			break;
	}
	USBX_SEL = 0;
	EA = 1;

	/* HIDϴ־ */
	PCx_HidUpStatus[ pcx ][ devx ] |= 0x01;
	PCx_HidUp_TimeCount[ pcx ][ devx ] = 0x00;	
}

/*******************************************************************************
* Function Name  : USBX_Devx_Endp_Init
* Description    : USBX豸ָ豸˵ʼ
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void USBX_Devx_Endp_Init( UINT8 pcx, UINT8 devx, UINT8 index ) 
{
	UINT8  j, k;
	UINT8  ep_mod;

	EA = 0;  					
	USBX_SEL = bUSBX_XSFR_OFS | bUSBX_XRAM_OFS | pcx;
	EA = 1;

	/* ˵ʹؼĴֵ */
	ep_mod = 0;
	for( j = 0; j < HostCtl[ index ].InterfaceNum; j++  )
	{
		for( k = 0; k < HostCtl[ index ].Interface[ j ].InEndpNum; k++ )
		{		
			if( ( ( HostCtl[ index ].Interface[ j ].InEndpAddr[ k ] & 0x0F ) > 0 ) && 
		 	    ( ( HostCtl[ index ].Interface[ j ].InEndpAddr[ k ] & 0x0F ) <= 6 )	)
			{
				ep_mod &= ~( 1 << ( HostCtl[ index ].Interface[ j ].InEndpAddr[ k ] & 0x0F ) );	
			}                                                                     
		}            
      
		for( k = 0; k < HostCtl[ index ].Interface[ j ].OutEndpNum; k++ )
		{
			if( ( ( HostCtl[ index ].Interface[ j ].OutEndpAddr[ k ] & 0x0F ) > 0 ) && 
		 	    ( ( HostCtl[ index ].Interface[ j ].OutEndpAddr[ k ] & 0x0F ) <= 6 )	)
			{
				ep_mod |= ( 1 << ( HostCtl[ index ].Interface[ j ].OutEndpAddr[ k ] & 0x0F ) );	
			} 
		}
	}
	if( devx == 0 )
	{
		pX0D0_EP_MOD = ep_mod;
	}
	else if( devx == 1 )
	{
		pX0D1_EP_MOD = ep_mod;
	}
	else if( devx == 2 )
	{
		pX0D2_EP_MOD = ep_mod;
	}				
}

/*******************************************************************************
* Function Name  : USBX_Hub_Wakeup
* Description    : USBX豸HUBѼ
* Input          : None
* Output         : None
* Return         : None									   
*******************************************************************************/
void USBX_Hub_Wakeup( void )
{
	UINT8  save;

	save = pUSBX0_CTRL;
	pUSBX0_CTRL	^= 0xC0;
	mDelaymS( 10 ); 
	pUSBX0_CTRL = save;
}
